/***************************************************************************
                          kbearinfoview.h  -  description
                             -------------------
    begin                : mn apr 15 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARINFOVIEW_H
#define KBEARINFOVIEW_H

//////////////////////////////////////////////////////
// Qt specific includes
/////////////////////////////////////////////////////
// KDE specific includes
#include <kdebug.h>
#include <kio/jobclasses.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "base/kbeartabview.h"
#include "base/kbearcopyjob.h"
#include "kbearlogview.h"
#include "kbeartransferview.h"

class KBearMdiChildView;
class QextMdiChildView;
class KBearLogView;
class KBearTransferView;
/**
  *@author Bjrn Sahlstrm
  */

class KBearInfoView : public KBearTabView  {
   Q_OBJECT
public: 
	/** No descriptions */
	KBearInfoView( QWidget* parent=0, const char* name=0 );
	/** No descriptions */
	virtual ~KBearInfoView();
	/** */
	void addLogPage( KBearMdiChildView* connectView, const QString& encoding );
	/** */
	void removeLogPage( const QString& name );
	/** */
	void showLogView();
	/** */
	void hideLogView();
	/** */
	void newTransfer( Transfer* );
	/** */
	void showTransferView();
	/** */
	void hideTransferView();
	/** */
	int numOfTransfers() const;
	/** */
	bool canStartTransfer( const QString& name, const QString& other );
	/** */
	void connectCopyJob( KBearCopyJob* );
	/** */
	bool hidden() { return m_logView->isHidden() && m_transferView->isHidden(); }
signals:
	/**  */
	void startTransfer( Transfer* );
	/** */
	void transfersFinished();
public slots:
	/** */
	void slotLogShowing();
	/** */
	void slotTransferShowing();
	/** */
	void slotLogHiding();
	/** */
	void slotTransferHiding();
private slots: // Private slots
	void slotChildWindowCloseRequest( QextMdiChildView* );
private: // Private attributes
	KBearLogView* m_logView;
	KBearTransferView* m_transferView;
};

#endif
