/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.CharStreamSource;
import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Config;
import au.id.jericho.lib.html.HTMLElements;
import au.id.jericho.lib.html.NodeIterator;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.StartTag;
import au.id.jericho.lib.html.StartTagType;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class TextExtractor
implements CharStreamSource {
    private final Segment segment;
    private boolean convertNonBreakingSpaces = Config.ConvertNonBreakingSpaces;
    private boolean includeAttributes = false;
    private boolean excludeNonHTMLElements = false;
    private static Map map = TextExtractor.initDefaultAttributeIncludeCheckerMap();
    private static AttributeIncludeChecker ALWAYS_INCLUDE = new AttributeIncludeChecker(){

        public boolean includeAttribute(StartTag startTag, Attribute attribute) {
            return true;
        }
    };
    private static AttributeIncludeChecker INCLUDE_IF_NAME_ATTRIBUTE_PRESENT = new AttributeIncludeChecker(){

        public boolean includeAttribute(StartTag startTag, Attribute attribute) {
            return startTag.getAttributes().get("name") != null;
        }
    };

    public TextExtractor(Segment segment) {
        this.segment = segment;
    }

    public void writeTo(Writer writer) throws IOException {
        writer.write(this.toString());
        writer.flush();
    }

    public long getEstimatedMaximumOutputLength() {
        return this.segment.length();
    }

    public String toString() {
        return new Processor(this.segment, this.getConvertNonBreakingSpaces(), this.getIncludeAttributes(), this.getExcludeNonHTMLElements()).toString();
    }

    public TextExtractor setConvertNonBreakingSpaces(boolean bl) {
        this.convertNonBreakingSpaces = bl;
        return this;
    }

    public boolean getConvertNonBreakingSpaces() {
        return this.convertNonBreakingSpaces;
    }

    public TextExtractor setIncludeAttributes(boolean bl) {
        this.includeAttributes = bl;
        return this;
    }

    public boolean getIncludeAttributes() {
        return this.includeAttributes;
    }

    public boolean includeAttribute(StartTag startTag, Attribute attribute) {
        AttributeIncludeChecker attributeIncludeChecker = (AttributeIncludeChecker)map.get(attribute.getKey());
        if (attributeIncludeChecker == null) {
            return false;
        }
        return attributeIncludeChecker.includeAttribute(startTag, attribute);
    }

    public TextExtractor setExcludeNonHTMLElements(boolean bl) {
        this.excludeNonHTMLElements = bl;
        return this;
    }

    public boolean getExcludeNonHTMLElements() {
        return this.excludeNonHTMLElements;
    }

    public boolean excludeElement(StartTag startTag) {
        return false;
    }

    private static Map initDefaultAttributeIncludeCheckerMap() {
        HashMap<String, AttributeIncludeChecker> hashMap = new HashMap<String, AttributeIncludeChecker>();
        hashMap.put("title", ALWAYS_INCLUDE);
        hashMap.put("alt", ALWAYS_INCLUDE);
        hashMap.put("label", ALWAYS_INCLUDE);
        hashMap.put("summary", ALWAYS_INCLUDE);
        hashMap.put("content", INCLUDE_IF_NAME_ATTRIBUTE_PRESENT);
        hashMap.put("href", ALWAYS_INCLUDE);
        return hashMap;
    }

    private final class Processor {
        private final Segment segment;
        private final Source source;
        private final boolean convertNonBreakingSpaces;
        private final boolean includeAttributes;
        private final boolean excludeNonHTMLElements;

        public Processor(Segment segment, boolean bl, boolean bl2, boolean bl3) {
            this.segment = segment;
            this.source = segment.source;
            this.convertNonBreakingSpaces = bl;
            this.includeAttributes = bl2;
            this.excludeNonHTMLElements = bl3;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.segment.length());
            Object object = new NodeIterator(this.segment);
            while (((NodeIterator)object).hasNext()) {
                Segment segment = ((NodeIterator)object).getNextSegment();
                if (segment instanceof Tag) {
                    Object object2;
                    Tag tag = (Tag)segment;
                    if (tag.getTagType().isServerTag()) {
                        object2 = tag.getElement();
                        if (object2 == null || ((Segment)object2).getEnd() <= tag.getEnd()) continue;
                        ((NodeIterator)object).skipToPos(((Segment)object2).getEnd());
                        continue;
                    }
                    if (tag.getTagType() == StartTagType.NORMAL) {
                        StartTag startTag = (StartTag)tag;
                        if (tag.name == "script" || tag.name == "style" || TextExtractor.this.excludeElement(startTag) || this.excludeNonHTMLElements && !HTMLElements.getElementNames().contains(tag.name)) {
                            ((NodeIterator)object).skipToPos(startTag.getElement().getEnd());
                            continue;
                        }
                        if (this.includeAttributes) {
                            object2 = startTag.getAttributes().iterator();
                            while (object2.hasNext()) {
                                Attribute attribute = (Attribute)object2.next();
                                if (!TextExtractor.this.includeAttribute(startTag, attribute)) continue;
                                stringBuffer.append(' ').append((Object)attribute.getValueSegment()).append(' ');
                            }
                        }
                    }
                    if (tag.getName() != "br" && HTMLElements.getInlineLevelElementNames().contains(tag.getName())) continue;
                    stringBuffer.append(' ');
                    continue;
                }
                Util.appendTo(stringBuffer, (CharSequence)segment);
            }
            object = CharacterReference.decodeCollapseWhiteSpace(stringBuffer, this.convertNonBreakingSpaces);
            return object;
        }
    }

    private static interface AttributeIncludeChecker {
        public boolean includeAttribute(StartTag var1, Attribute var2);
    }
}

