/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

final class IntStringHashMap {
    private static final int DEFAULT_INITIAL_CAPACITY = 15;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient Entry[] entries;
    private transient int size;
    private int threshold;
    private float loadFactor;
    private int bitmask;

    public IntStringHashMap(int n, float f) {
        int n2;
        this.loadFactor = f;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.threshold = (int)((float)n2 * f);
        this.entries = new Entry[n2];
        this.bitmask = n2 - 1;
    }

    public IntStringHashMap(int n) {
        this(n, 0.75f);
    }

    public IntStringHashMap() {
        this(15, 0.75f);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private int getIndex(int n) {
        return n & this.bitmask;
    }

    public String get(int n) {
        Entry entry = this.entries[this.getIndex(n)];
        while (entry != null) {
            if (n == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private Entry getEntry(int n) {
        Entry entry = this.entries[this.getIndex(n)];
        while (entry != null && n != entry.key) {
            entry = entry.next;
        }
        return entry;
    }

    public boolean containsKey(int n) {
        return this.getEntry(n) != null;
    }

    public String put(int n, String string) {
        int n2 = this.getIndex(n);
        Entry entry = this.entries[n2];
        while (entry != null) {
            if (n == entry.key) {
                String string2 = entry.value;
                entry.value = string;
                return string2;
            }
            entry = entry.next;
        }
        this.entries[n2] = new Entry(n, string, this.entries[n2]);
        if (this.size++ >= this.threshold) {
            this.increaseCapacity();
        }
        return null;
    }

    private void increaseCapacity() {
        int n = this.entries.length;
        Entry[] entryArray = this.entries;
        this.entries = new Entry[n << 1];
        this.bitmask = this.entries.length - 1;
        for (int i = 0; i < n; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Entry entry2 = entry.next;
                int n2 = this.getIndex(entry.key);
                entry.next = this.entries[n2];
                this.entries[n2] = entry;
                entry = entry2;
            }
        }
        this.threshold = (int)((float)this.entries.length * this.loadFactor);
    }

    public String remove(int n) {
        int n2 = this.getIndex(n);
        Entry entry = null;
        Entry entry2 = this.entries[n2];
        while (entry2 != null) {
            if (n == entry2.key) {
                if (entry == null) {
                    this.entries[n2] = entry2.next;
                } else {
                    entry.next = entry2.next;
                }
                --this.size;
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry.next;
        }
        return null;
    }

    public void clear() {
        for (int i = this.bitmask; i >= 0; --i) {
            this.entries[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(String string) {
        if (string == null) {
            for (int i = this.bitmask; i >= 0; --i) {
                Entry entry = this.entries[i];
                while (entry != null) {
                    if (entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            for (int i = this.bitmask; i >= 0; --i) {
                Entry entry = this.entries[i];
                while (entry != null) {
                    if (string.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    private static final class Entry {
        final int key;
        String value;
        Entry next;

        public Entry(int n, String string, Entry entry) {
            this.key = n;
            this.value = string;
            this.next = entry;
        }
    }
}

