/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.jca.inflowmdb;

import org.jboss.logging.Logger;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.annotation.ejb.ResourceAdapter;

import javax.ejb.MessageDriven;
import javax.ejb.ActivationConfigProperty;
import javax.jms.Message;
import javax.jms.MessageListener;

/**
 *
 * @version <tt>$Revision: 63914 $</tt>
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 */
@MessageDriven(activationConfig =
{
@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"),
@ActivationConfigProperty(propertyName="destination", propertyValue="queue/inflowmdbtest"),
@ActivationConfigProperty(propertyName="maxSession", propertyValue="1")
})
@ResourceAdapter("jms-ra.rar")
@PoolClass(value=org.jboss.ejb3.StrictMaxPool.class, maxSize=1, timeout=10000)
public class JMSMDBBean implements MessageListener
{
   private static final Logger log = Logger.getLogger(JMSMDBBean.class);

   public static boolean called = false;
   
   public void onMessage(Message recvMsg)
   {
      log.info("************** here!!!!");
      called = true;
   }
}
