// -*- C++ -*-
// --------------------------------------------------------------------
// Overlay for creating IpePath objects
// --------------------------------------------------------------------
/*

    This file is part of the extensible drawing editor Ipe.
    Copyright (C) 1993-2005  Otfried Cheong

    Ipe is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exception, you have permission to link Ipe with the
    CGAL library and distribute executables, as long as you follow the
    requirements of the Gnu General Public License in regard to all of
    the software in the executable aside from CGAL.

    Ipe is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details.

    You should have received a copy of the GNU General Public License
    along with Ipe; if not, you can find it at
    "http://www.gnu.org/copyleft/gpl.html", or write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef IPECREATEPATH_H
#define IPECREATEPATH_H

#include "ipeoverlay.h"

// --------------------------------------------------------------------

class IpeSegmentSubPath;

class IpeCreateRectangle : public IpeOverlay {
 public:
  IpeCreateRectangle(QMouseEvent *ev, IpeCanvas *canvas,
		     IpeOverlayServices *services);

  virtual void Draw(QPaintEvent *ev, QPainter *painter) const;
  virtual void MousePress(QMouseEvent *ev);
  virtual void MouseMove(QMouseEvent *ev);

private:
  void Compute();

private:
  IpeOverlayServices *iServices;
  bool iSquare;
  IpeVector iV[2];
};

class IpeCreateSplinegon : public IpeOverlay {
 public:
  IpeCreateSplinegon(QMouseEvent *ev, IpeCanvas *canvas,
		     IpeOverlayServices *services);

  virtual void Draw(QPaintEvent *ev, QPainter *painter) const;
  virtual void MousePress(QMouseEvent *ev);
  virtual void MouseMove(QMouseEvent *ev);
  virtual void KeyPress(QKeyEvent *ev);
  void Explain() const;

 private:
  IpeOverlayServices *iServices;
  std::vector<IpeVector> iV;
};

class IpeCreatePath : public IpeOverlay {
 public:
  IpeCreatePath(QMouseEvent *ev, IpeCanvas *canvas, IpeOverlayServices *services,
		bool closed, bool spline);
  virtual ~IpeCreatePath();

  virtual void Draw(QPaintEvent *ev, QPainter *painter) const;
  virtual void MousePress(QMouseEvent *ev);
  virtual void MouseMove(QMouseEvent *ev);
  virtual void KeyPress(QKeyEvent *ev);

 private:
  static IpeMatrix ComputeMatrix(const IpeVector &v0, const IpeVector &v1,
				 const IpeVector &v2);

  bool Decrease(int k, std::vector<IpeVector> &v);
  void RecomputeMatrix();
  void Update();

 private:
  IpeOverlayServices *iServices;
  IpeSegmentSubPath *iSP;
};

// --------------------------------------------------------------------
#endif
