/*  Color management example.
 *
 *  color.h
 *
 *  Inti Translation of the GtkGLExt color management example
 *  written by Naofumi Yasufuku <naofumi@users.sourceforge.net>.
 */

#include <inti/main.h>
#include <inti/core.h>
#include <inti/gdk/gl/config.h>
#include <inti/gtk/gl/drawingarea.h>

using namespace Inti;

/*  GLDrawingArea
 */

class GLDrawingArea : public Gtk::GL::DrawingArea
{
	std::vector<Gdk::Color> colors;

	static void examine_attrib(Gdk::GL::Config& glconfig);
	static void print_attrib(Gdk::GL::Config& glconfig, const char *attrib_str, int attrib, bool is_boolean);

protected:
	virtual bool on_configure_event(const Gdk::EventConfigure& event);
	virtual bool on_expose_event(const Gdk::EventExpose& event);

public:
	GLDrawingArea(Gdk::GL::Config *glconfig);
	virtual ~GLDrawingArea();
};

/* Window
 */

class Window : public Gtk::Window
{
public:
	Window(Gdk::GL::Config *glconfig);
	virtual ~Window();
};

