#!/bin/bash

cat >file.head <<\END
/*
    FUNIONFS: UNIONFS over FUSE Usermode filesystem
    Copyright (C) 2005-2006  Stephane APIOU <stephane.apiou@free.fr>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
END
for i in $*
do 
	awk '
	BEGIN { val=0 }
	($0 == "/*") && (val == 0) { val =1 }
	($0 !~ /^[ \t]*$/) && (val == 0) { val = 2 ;system("cat file.head") }
	($0 == "*/") && (val == 1) { getline; system("cat file.head"); val = 2}
	val == 2 { print }' <$i | indent -bad -bap -bbb -bbo -nbc -bl -bli0 -bls -nbs -ncdb -ncdw -nce -ci8 -cli0 -cs -nbfda -nbfde -di1 -nfc1 -nfca -nhnl -i8 -nip -l80 -lp -npcs -nprs -psl -saf -sai -saw -sc -nsob -ss -ts8 -ut >output
	cmp -s output $i || cp output $i
	rm -f output
done
rm -f file.head
