package freenet.transport;

import java.io.IOException;
import java.net.*;

/**
 * Transport object for TCP.
 *
 * @author oskar
 */
public class TCP extends tcpTransport {

    public TCP(int preference) {
        super(preference);
    }

    public TCP(InetAddress bindAddr, int preference) {
        super(bindAddr, preference);
    }

    public TCP(InetAddress bindAddr, int designator, int preference) {
        super(bindAddr, designator, preference);
    }

    public final String getName() {
        return "tcp";
    }

    public final tcpSocketFactory getSocketFactory() {
        return socketFactory;
    }

    public final tcpServerSocketFactory getServerSocketFactory() {
        return serverSocketFactory;
    }


    // these should be anonymous classes but whatever

    private static final tcpSocketFactory socketFactory =
        new privSocketFactory();
    
    private static final tcpServerSocketFactory serverSocketFactory =
        new privServerSocketFactory();

    /** proxy the calls to ordinary Socket constructors */
    private static final class privSocketFactory extends tcpSocketFactory {
        Socket createSocket(InetAddress host, int port) throws IOException {
            return new Socket(host, port);
        }
        Socket createSocket(InetAddress address, int port,
                            InetAddress clientAddress, int clientPort) throws IOException {
            return new Socket(address, port, clientAddress, clientPort);
        }
        Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return new Socket(host, port);
        }
        Socket createSocket(String host, int port,
                            InetAddress clientHost, int clientPort) throws IOException,
                                                                           UnknownHostException {
            return new Socket(host, port, clientHost, clientPort);
        }
    }

    /** proxy the calls to ordinary ServerSocket constructors */
    private static final class privServerSocketFactory extends tcpServerSocketFactory {
        ServerSocket createServerSocket(int port) throws IOException {
            return new ServerSocket(port);
        }
        ServerSocket createServerSocket(int port, int backlog) throws IOException {
            return new ServerSocket(port, backlog);
        }
        ServerSocket createServerSocket(int port, int backlog,
                                        InetAddress ifAddress) throws IOException {
            return new ServerSocket(port, backlog, ifAddress);
        }
    }
}


