package freenet.thread;

/**
 * The SimpleThreadFactory always creates a new Thread.  It may be useful
 * for disabling thread pooling or for ensuring a group of related threads
 * are created under a ThreadGroup controlled by the owner of the object.
 * @author tavin
 */
public final class SimpleThreadFactory implements ThreadFactory {

    private final ThreadGroup tg;
    
    /**
     * No ThreadGroup (created threads inherit the ThreadGroup
     * of the creating thread).
     */
    public SimpleThreadFactory() {
        this(null);
    }

    /**
     * Threads will be created belonging to this ThreadGroup.
     */
    public SimpleThreadFactory(ThreadGroup tg) {
        this.tg = tg;
    }

    /**
     * @return  zero
     */
    public final int activeThreads() {
        return 0;
    }

    /**
     * @return  a lot
     */
    public final int availableThreads() {
        return Integer.MAX_VALUE;
    }

    /**
     * Always instantiates a new Thread.
     */
    public final Thread getThread(Runnable r, boolean force) {
        return new Thread(tg, r);  // null ThreadGroup is OK
    }
}


