package freenet.support.test;
import junit.framework.TestCase;
import java.util.Random;
import freenet.crypt.Yarrow;
import freenet.Core;
import freenet.support.Fields;
/**
 * Unit test for methods in Fields.
 *
 * @author oskar
 */

public class FieldsTest extends TestCase {

    public static final void main(String[] args) {
        SimpleTestRunner.main(
            new String[] { FieldsTest.class.getName() }
        );
    }

    
    Random random;

    public FieldsTest(String name) {
        super(name);
    }

    public void setUp() {
        if (Core.randSource != null)
            random = Core.randSource;
        else
            random = new Yarrow();
    }

    public void tearDown() {
        random = null;
    }

    public void testLongs() {
        // typical numbers

        long[] vals = { 
            0, 1, -1, 2, 10, 16, 255, 99999, -99999, 1000000000,
            Long.MAX_VALUE, Long.MIN_VALUE
        };
        String[] strings = {
            "0", "1", "ffffffffffffffff","2","a","10","ff","1869f",
            "fffffffffffe7961", "3b9aca00", "7fffffffffffffff",
            "8000000000000000"
        };

        for (int i = 0; i < vals.length ; i++) {
            assertEquals("Testing encoding of " + vals[i], strings[i],
                         Fields.longToString(vals[i]));
            assertEquals("Testing decoding of " + strings[i], vals[i],
                         Fields.stringToLong(strings[i]));
        }

        // now for some random
        for (int i = 0 ; i < 1000 ; i++) {
            long l = random.nextLong();
            assertEquals("Checking encode/decode of " + l,
                         l, Fields.stringToLong(Fields.longToString(l)));
        }

        // check failure
        try {
            Fields.stringToLong("xxx");
            fail("Didn't throw NFE on decoding 'xxx'");
        } catch (NumberFormatException e) {
        }

        try {
            Fields.stringToLong("112233445566778899");
            fail("Didn't throw NFE on decoding 18 characters");
        } catch (NumberFormatException e) {
        }
    }

    public void testHexBytes() {
        byte[][] vals = {
            new byte[] {},
            new byte[] {0},
            new byte[] {-5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5},
            new byte[] {(byte) 0x80, (byte) 0xff, 0x00, 0x01, 0x7f}
        };

        String[] strings = {
            "",
            "00",
            "fbfcfdfeff000102030405",
            "80ff00017f"
        };

        for (int i = 0; i < vals.length ; i++) {
            assertEquals("Testing encoding of array " + i, strings[i],
                         Fields.bytesToHex(vals[i]));
            assertTrue("Testing decoding of " + strings[i], 
                       arrayEquals(vals[i], Fields.hexToBytes(strings[i])));
        }

        for (int i = 0 ; i < 1000 ; i++) {
            byte[] b = new byte[random.nextInt() & 0x3f];
            StringBuffer sb = new StringBuffer();
            for (int j = 0 ; j < b.length ; j++) {
                b[j] = (byte) (random.nextInt() & 0xff);
                sb.append(b[j]);
                if (j < b.length - 1)
                    sb.append(',');
            }
            assertTrue("Checking encode/decode of array " + sb, 
                       arrayEquals(b, 
                                   Fields.hexToBytes(Fields.bytesToHex(b))));
        }
    }

    private boolean arrayEquals(byte[] a, byte[] b) {
        if (a.length != b.length)
            return false;
        for (int i = 0 ; i < a.length ; i++) {
            if (a[i] != b[i])
                return false;
        }
        return true;
    }
    

}
