package freenet.support.servlet;
import java.io.*;
import java.util.*;

/**
 * A template of text into which values in a Dictionary may be
 * inserted.  The template is read from an InputStream and
 * everything is pre-processed to make the actual generation
 * of the complete document as rapid as possible.  Values
 * to be replaced in the template should be in the format
 * ##VALUE##.  Behavior is undefined if this syntax is
 * abused (eg. having an odd number of '##' in the template).
 **/
public class HtmlTemplate  {

  /* For testing only
  public static void main(String[] args)
    throws Exception
  {
    TextTemplate tt = new TextTemplate(new FileInputStream(new File(args[0])));
    tt.set("key1","data1");
    tt.set("key2","data2");
    System.out.println(tt.toString());
    PrintWriter out = new PrintWriter(System.out);
    tt.toPrintWriter(out);
    out.flush();
  }
  */

  /**
   * A list of Fragments, each of which can either be a plain piece
   * of text, or a variable to be replaced in the template
   **/
  Vector fragments = new Vector();

  /**
   * A hashtable which stores the desired Strings or TemplateElements
   * for each given variable
   **/
  Hashtable d = new Hashtable();

  public HtmlTemplate(InputStream template) 
    throws IOException
  {
    // Parse the template into the fragments vector
    BufferedInputStream bTemplate = new BufferedInputStream(template);

    // We use a and b to keep track of the last and second last characters
    // to be read from the stream
    int a=bTemplate.read();
    int b=bTemplate.read();
    // The ele bool is true if and only if we are reading a ##variable## rather than
    // plain text
    boolean ele=false;
    if ((a==-1) || (b==-1))
      throw new // FIXME: This is ugly, why shouldn't it be less than two characters?
	RuntimeException("Template file cannot be less than two characters in length");
    StringBuffer sb = new StringBuffer(5000);

    // Now parse through the string
    while(true)  {
      // If the last two characters read were "##" then...
      if ((a==(int) '#') && (b==(int) '#'))  {
	if (ele)  { // We just finished reading a variable
	  fragments.addElement(new VarFragment(sb.toString()));
	}
	else  { // We just finished reading a string
	  fragments.addElement(new StringFragment(sb.toString()));
	}
	// Clear the StringBuffer
	// FIXME: It would be cleaner to have something similar to a StringBuffer
	// so we could reuse the allocated space - alas StringBuffer doesn't
	// provide this functionality
	sb.setLength(0);
	ele = !(ele);
	// Read next char
	a=bTemplate.read();
	// Handle EOF
	if (a == -1)
	  break;
	b=bTemplate.read();
	if (b == -1)
	  break;
      }
      else  {
	// Add this char to our StringBuffer and read the next one
	sb.append((char) a);
	a=b;
	b=bTemplate.read();
	if (b == -1)
	  break;
      }
    }
    if (ele)  {
      fragments.addElement(new VarFragment(sb.toString()));
    }
    else  {
      fragments.addElement(new StringFragment(sb.toString()));
    }
    sb.setLength(0);
    ele = !(ele);
  }

  /**
   * Set a variable to a String value
   * @param var The variable to set
   * @param val The value to set it to
   **/
  public void set(String var, String val) {
    d.put(var,val);
  }

  /**
   * Set a variable to the output of a TemplateElement
   * @param var The variable to set
   * @param val The TemplateElement which will produce the output
   *            to replace the variable in the template.
   **/
  public void set(String var, TemplateElement val) {
    d.put(var,val);
  }

  /**
   * Write the template to a PrintWriter
   **/
  public void toPrintWriter(PrintWriter pw)  {
    for (Enumeration e = fragments.elements(); e.hasMoreElements();) {
      ((Fragment) e.nextElement()).toPrintWriter(pw, d);
    }
  }
  
  /* For testing only
  public String toString()
  {
    StringBuffer ret = new StringBuffer();
    for (Enumeration e = fragments.elements(); e.hasMoreElements();) {
      ret.append(((Fragment) e.nextElement()).toString());
      ret.append("\n");
    }
    return ret.toString();
  }
  */
}

interface Fragment  {
  public void toPrintWriter(PrintWriter pw, Dictionary d);
}

class StringFragment implements Fragment  {
  String s;
  public StringFragment(String s)  {
    this.s = s;
  }

  public void toPrintWriter(PrintWriter pw, Dictionary d)  {
    pw.print(s);
  }

  /* For testing only
  public String toString()
  {
    return "StringFragment: \""+s+"\"";
  }
  */
}

class VarFragment implements Fragment  {
  String v;
  public VarFragment(String v)  {
    this.v = v;
  }

  public void toPrintWriter(PrintWriter pw, Dictionary d)  {
    Object o = d.get(v);
    if (o == null)  {
	o = "##"+v+"##";
    }
    if (o instanceof TemplateElement)  {
      ((TemplateElement) o).toHtml(pw);
      }
    else {
      pw.print((String) o);
    }
  }

  /* For testing only
  public String toString()
  {
    return "VarFragment: \""+v+"\"";
  }
  */
}
