package freenet.presentation;

import freenet.*;
import freenet.support.io.DiscontinueInputStream;
import java.io.*;

public class ClientProtocol extends Presentation {

    public static int DESIGNATOR = 0x0002;

    public int designatorNum() {
        return DESIGNATOR;
    }

    /**
     * Creates a new RawMessage of a connection by reading this presentation. This
     * method locks until an entire message has been read (excluding trailing)
     * @param c     The connectio to read
     * @return      A new raw message
     */
    public RawMessage readMessage(InputStream in) 
        throws InvalidMessageException, EOFException{

        return new FCPRawMessage(in);
    }


    /** 
     * Creates a new RawMessage of a given type that uses this presentation
     * @param messageType   The name of the message type
     * @param close         Whether to keep alive the connection after 
     *                      receiving or sending this message.
     * @param sustain       Whether to sustain the connection.
     * @param fs            A set of message specific fields.
     * @param trailingLength The length of the trailing data, or 0 if there 
     *                       is no trailing data
     * @param trailingName   The name of the trailing field, or null if there
     *                       is no trailing data
     * @param data           An inputstream containing the trailing data,
     *                       straight off the DataStore (decrypted).
     * @return     A new raw message
     **/
    public  RawMessage newMessage(String messageType, boolean close, 
                                  boolean sustain, FieldSet fs, 
                                  long trailingLength, 
                                  String trailingName, 
                                  DiscontinueInputStream data) {
        return new FCPRawMessage(
            messageType, close, fs, trailingLength, trailingName, data
        );
    }

    public int exptMessageSize() {
        return 5000;
    }
}
