package freenet.node.states.FCP;

import freenet.*;
import freenet.node.*;
import freenet.node.states.request.*;
import freenet.message.client.*;
import freenet.client.*;

/**
 * This is the state pertaining to ClientGets in their
 * initial state.
 */

public class NewClientGet extends NewClientRequest {

    public NewClientGet(long id, ConnectionHandler source) {
        super(id, source);
    }
    
    /**
     * Returns the name.
     * @return "New ClientGet"
     */
    public String getName() {
        return "New ClientGet";
    }

    public State received(Node n, MessageObject mo) throws StateException {

        if (!(mo instanceof ClientGet)) {
            throw new BadStateException("expecting ClientGet");
        }
        
        n.diagnostics.occurrenceCounting("inboundClientRequests", 1);

        ClientGet cgmo = (ClientGet) mo;
        
        try {
            ClientKey ckey =
                AbstractClientKey.createFromRequestURI(cgmo.getURI());
            Key k = ckey.getKey();
            if (k == null) throw new KeyException("got null Key");
            FeedbackToken ft    = new ClientGetToken(id, source, ckey);
            RequestInitiator ri = new RequestInitiator(id);
            return (new DataPending(id, cgmo.getHTL(),
                                    k, null, ft, ri)).received(n, ri);
        }
        catch (KeyException e) {
            sendMessage(new URIError(id, e.getMessage()));
        }
        return null;
    }
}



