package freenet.node.states.FCP;

import freenet.*;
import freenet.message.client.*;
import freenet.node.states.request.FeedbackToken;
import freenet.node.Node;
import java.io.*;

/** FeedbackToken to translate the results from the node's request states
  * to FCP responses.
  */
abstract class FCPFeedbackToken implements FeedbackToken {

    // the id of the associated state chain
    long id;
    // the active connection
    protected ConnectionHandler source;

    protected boolean waiting = true;

    FCPFeedbackToken(long id, ConnectionHandler source) {
        this.id     = id;
        this.source = source;
    }

    public void queryRejected(Node n, int htl, String reason, FieldSet fs,
                              int unreachable, int restarted, int rejected)
                                                throws SendFailedException {
        if (waiting)
            sendMessage(new RouteNotFound(id, reason, unreachable,
                                          restarted, rejected));
        else
            sendMessage(new Failed(id, reason));
    }

    public void restarted(Node n, long millis) throws SendFailedException {
        waiting = true;
        sendMessage(new Restarted(id, millis));
    }
    
    public void dataNotFound(Node n, long timeOfQuery) throws SendFailedException {
        sendMessage(new DataNotFound(id));
    }
    
    protected OutputStream sendMessage(ClientMessage cm) throws SendFailedException {
        return source.sendMessage(cm);
    }
}



