package freenet.node;
import freenet.*;
import freenet.support.*;

/**
 * Interface of generic non-message events in the node.
 * 
 * @author oskar
 */

public abstract class EventMessageObject implements NodeMessageObject, 
                                                    Schedulable {
    
    private TickerToken tt;
    protected final long id;
    protected final boolean external;

    public EventMessageObject(long id, boolean external) {
	this.id = id;
        this.external = external;
    }

    public final long id() {
        return id;
    }

    public State getInitialState() throws BadStateException {
	throw new BadStateException("Internal event object received " 
				    + "with no states. Chain probably ended.");
    }

    public final boolean isExternal() {
        return external;
    }

    /** The Ticker calls this to give the token for cancelling.
      * (it's kind of a "setToken")
      */
    public final void getToken(TickerToken tt) {
	this.tt = tt;
    }

    /** @return  true if this MO was ever scheduled on the ticker
      */
    public final boolean scheduled() {
        return tt != null;
    }

    /**
     * Cancels this Event from the last Ticker it was added to.
     * @return True if it was cancelled, false otherwise (unscheduled or
     *         already executed).
     */
    public final boolean cancel() {
	return tt != null && tt.cancel();
    }

    /**
     * If a RequestObject is dropped, it cancels itself.
     */
    public void drop(Node n) {
        cancel();
    }
}


