package freenet.message.client;

import freenet.*;
import freenet.node.Node;
import freenet.client.FreenetURI;
import java.io.InputStream;
import java.net.MalformedURLException;

/** Superclass of FCP ClientGet and ClientPut messages.
  * @author tavin
  */
public abstract class ClientRequest extends ClientMessage {

    protected FreenetURI uri;
    protected final int hopsToLive;

    public ClientRequest(ConnectionHandler source, RawMessage raw) {
        this(source, raw, false);
    }
    
    public ClientRequest(ConnectionHandler source, RawMessage raw, boolean getData) {
        super(source, raw, getData);
        int htl = -1;
        try {
            uri = new FreenetURI(otherFields.get("URI"));
            otherFields.remove("URI");
            htl = Integer.parseInt(otherFields.get("HopsToLive"), 16);
            otherFields.remove("HopsToLive");
        }
        catch (Exception e) {
            formatError = true;
        }
        
        if (htl < 0) formatError = true;
        else if (htl > Node.maxHopsToLive) htl = Node.maxHopsToLive;

        hopsToLive = htl;
    }
    
    public FreenetURI getURI() {
        return uri;
    }

    public int getHTL() {
        return hopsToLive;
    }
}


