package freenet.message;
import freenet.*;
import freenet.node.*;
import freenet.support.Logger;
import freenet.support.Fields;
/**
 * The message sent when a DataRequest runs out of htl without finding the 
 * data.
 *
 * @author oskar
 */

public class DataNotFound extends NodeMessage {

    public static final String messageName = "DataNotFound";

    private long timeOfQuery = 0;

    public DataNotFound(long idnum) {
	super(idnum, null);
        timeOfQuery = System.currentTimeMillis();
    }

    public DataNotFound(long idnum, long timeOfQuery) {
        super(idnum, null);
        this.timeOfQuery = timeOfQuery;
    }

    public DataNotFound(ConnectionHandler source, 
                        RawMessage raw) throws InvalidMessageException {
	super(source, raw);
        String tsq = otherFields.get("TimeSinceQuery");
        if (tsq != null) {
            otherFields.remove("TimeSinceQuery");
            try {
                timeOfQuery = 
                    System.currentTimeMillis() - Fields.hexToLong(tsq);
            } catch (NumberFormatException e) {
            }
        }
        if (timeOfQuery <= 0) {
            timeOfQuery = System.currentTimeMillis();
        }
    }

    public RawMessage toRawMessage(Presentation t) {
	RawMessage raw=super.toRawMessage(t);
        raw.fs.add("TimeSinceQuery", 
                   Fields.longToHex(System.currentTimeMillis() - timeOfQuery));
	return raw;
    }

    public String getMessageName() {
        return messageName;
    }

    public long timeOfQuery() {
        return timeOfQuery;
    }

}


