package freenet.fs.dir;

import freenet.fs.acct.*;
import freenet.fs.acct.sys.*;
import freenet.support.*;
import freenet.support.BinaryTree.Node;
import java.util.Enumeration;

/**
 * A map of Ticket objects.  Used by the TicketManager.
 * @author tavin
 */
final class TicketMap extends AccountingTree {


    /**
     * @param proc  the AccountingProcess allocated for this tree
     * @param live  whether this is the map for active (live) tickets.
     *              if true, the entire tree will remain in memory.
     *              if false, the entire tree will remain on disk.
     */
    TicketMap(AccountingProcess proc, boolean live) {
        super(proc, new Ticket.Marshal(),
              live ? (Cache) new UnlimitedCache()
                   : (Cache) new NullCache());
    }


    final Ticket get(long ticketID) {
        Node n = treeSearch(new Ticket(ticketID));
        return n == null ? null : (Ticket) n.getObject();
    }

    final void put(Ticket t) {
        treeInsert(new AccountingTreeNode(t), true);
    }

    final Ticket remove(long ticketID) {
        Node n = treeRemove(new Ticket(ticketID));
        return n == null ? null : (Ticket) n.getObject();
    }

    final Walk tickets() {
        return new TicketWalk(treeWalk(true));
    }

    private static final class TicketWalk implements Walk {
        private final Walk walk;
        TicketWalk(Walk walk) {
            this.walk = walk;
        }
        public final Object getNext() {
            Node n = (Node) walk.getNext();
            return n == null ? null : n.getObject();
        }
    }
}


