package freenet.fs.dir;

import java.util.Enumeration;
import java.io.*;

/**
 * A Directory implementation that drops everything
 * through to a directory in the native FS.
 * @author tavin
 */
public class NativeFSDirectory implements Directory {

    public final File root;
    public final long size;
    
    /**
     * @param root  the File object corresponding to the
     *              native FS directory backing the implementation
     * @param size  the maximum number of bytes to allow to be stored
     */
    public NativeFSDirectory(File root, long size) {
        this.root = root;
        this.size = size;
    }
    

    public final Object semaphore() {
        return this;
    }

    public boolean dirty() {
        return false;
    }
    
    public long flush() throws IOException {
        return -1;
    }

    public long available() {
        return -1;
    }

    public Enumeration keys(boolean ascending) {
        return null;
    }

    public Enumeration keys(FilePattern pat) {
        return null;
    }

    public Enumeration lruKeys(boolean ascending) {
        return null;
    }

    public boolean delete(FileNumber fn) {
        return false;
    }

    public boolean contains(FileNumber fn) {
        return false;
    }
    
    public Buffer fetch(FileNumber fn) {
        return null;
    }

    public Buffer store(long size, FileNumber fn) {
        return null;
    }
}
    


