package freenet.fs.dir;

import freenet.support.Bucket;
import freenet.support.BucketFactory;
import java.io.*;


public class FSBucketFactory implements BucketFactory {

    protected final LossyDirectory dir;
    
    public FSBucketFactory(LossyDirectory dir) {
        this.dir = dir;
    }
    
    public final Bucket makeBucket(long size) throws IOException {
        //return new FSBucket(dir.forceStore(size, FileNumber.NIL));
        Buffer buf = dir.forceStore(size, FileNumber.NIL);
        freenet.Core.logger.log(this,
                                "making bucket: "+buf,
                                freenet.Core.logger.DEBUG);
        return new FSBucket(buf);
    }

    private final class FSBucket implements Bucket {

        private final Buffer buffer;
        private boolean released = false;

        FSBucket(Buffer buffer) {
            this.buffer = buffer;
        }
        
        public final InputStream getInputStream() throws IOException {
            return buffer.getInputStream();
        }

        public final OutputStream getOutputStream() throws IOException {
            return buffer.getOutputStream();
        }

        public final String getName() {
            return this.toString();
        }

        public final void resetWrite() {}

        public final long size() {
            return buffer.length();
        }

        final void release() {
            if (!released) {
                synchronized (dir.semaphore()) {
                    if (!released) {  // check again, now that we are synced
                        freenet.Core.logger.log(FSBucketFactory.this,
                                                "freeing bucket: "+buffer,
                                                freenet.Core.logger.DEBUG);
                        released = true;
                        buffer.release();
                    }
                }
            }
        }

        protected final void finalize() throws Throwable {
            release();
        }
    }


    public final void freeBucket(Bucket b) throws IOException {
        FSBucket fsb = (FSBucket) b;
        fsb.release();
    }
}


