package freenet.fs.acct.sys;

import freenet.support.*;
import freenet.support.Comparable;
import freenet.support.RedBlackTree.RBNodeImpl;

/**
 * This is what the user of the AccountingTree sees as the Node objects
 * of the tree.  If an entry is to be inserted in the tree, it must be
 * an instance of this class.  Nodes returned by the AccountingTree are
 * instances of this class.
 * @author tavin
 */
public final class AccountingTreeNode extends RBNodeImpl {

    int num;

    SerialTree owner = null;


    
    public AccountingTreeNode(Comparable entry) {
        this(entry, -1);
    }

    AccountingTreeNode(Comparable entry, int num) {
        super(entry);
        this.num = num;
    }

    AccountingTreeNode(AccountingTreeNode atn) {
        super(atn.getObject());
        this.num = atn.num;
    }


    final void retire() {
        setParent(null);
        AccountingTreeNode leftChild = (AccountingTreeNode) getLeftChild();
        AccountingTreeNode rightChild = (AccountingTreeNode) getRightChild();
        if (leftChild != null)
            leftChild.retire();
        if (rightChild != null)
            rightChild.retire();
    }



/*
    public final Comparable getObject() {
        return subtreeNode.getObject();
    }

    public final boolean hasParent() {
        return subtreeNode.hasParent();
    }

    public final Node getParent() {
        return subtreeNode.getParent();
    }

    public final void setParent(Node node) {
        subtreeNode.setParent(node);
    }

    public final boolean hasLeftChild() {
        return subtreeNode.hasLeftChild();
    }

    public final Node getLeftChild() {
        return subtreeNode.getLeftChild();
    }

    public final void setLeftChild(Node node) {
        subtreeNode.setLeftChild(node);
    }

    public final boolean hasRightChild() {
        return subtreeNode.hasRightChild();
    }

    public final Node getRightChild() {
        return subtreeNode.getRightChild();
    }

    public final void setRightChild(Node node) {
        subtreeNode.setRightChild(node);
    }
*/

}


