package freenet.fs.acct.fsck;

/**
 * Represents an inconsistency revealed in the fault analysis
 * of an accounting system or subsystem.  If the severity of
 * the fault is low enough, it may be repaired.
 * @author tavin
 */
public interface Fault {

    /**
     * Fault severities:
     *      MINOR = no information loss
     *      MAJOR = reparable, but information loss
     *      FATAL = irreparable damage;  start over
     */
    int MINOR = 0,
        MAJOR = 1,
        FATAL = 2;

    /**
     * @return  a message explaining the problem and possibility of repair
     */
    String getDescription();

    /**
     * @return  the severity level of this fault (primary ordering)
     * The highest severity faults occur first in ascending order.
     */
    int getSeverity();
    
    /**
     * Repairs the fault.
     * @throws IllegalStateException
     *         if the severity of the fault is FATAL
     */
    void fix();
}




