package freenet.fs.acct;

import java.io.*;
import java.util.Vector;
import java.util.Enumeration;

/**
 * @author tavin
 */
class AnnotationBlock extends ControlBlock {
    
    private final Vector btxList = new Vector();
    private int bodySize = 2;  // reserve at least 2 zero bytes at the end
                               // to terminate the series of records
    
    AnnotationBlock(int bnum, int antecedent) {
        super(bnum, ANNOTATION_BLOCK, antecedent);
    }

    AnnotationBlock(int bnum, AnnotationBlock ab) {
        super(bnum, ANNOTATION_BLOCK, ab.getBlockNumber());
        this.next = ab;
    }

    AnnotationBlock(int bnum, int antecedent, DataInput din) throws IOException {        
        super(bnum, ANNOTATION_BLOCK, antecedent);
        int len;
        while (0 != (len = din.readUnsignedShort())) {
            byte[] annot = new byte[len];
            din.readFully(annot);
            BlockTransaction btx = new BlockTransaction(din.readInt(), din.readInt());
            btx.annotate(annot);
            add(btx);
        }
    }

    public String toString() {
        return super.toString() + " Records: " + btxList.size();
    }
    

    final void add(BlockTransaction btx) {
        btxList.addElement(btx);
        bodySize += btx.getRecordLength();
    }

    final Enumeration getAnnotations() {
        return btxList.elements();
    }

    /**
     * @return  the number of bytes needed to serialize
     *          the annotation block
     */
    final int getBodySize() {
        return bodySize;
    }

    void writeBody(DataOutput out) throws IOException {
        Enumeration bte = btxList.elements();
        while (bte.hasMoreElements()) {
            BlockTransaction btx = (BlockTransaction) bte.nextElement();
            if (btx.getAnnotationLength() > 0) {
                out.writeShort(btx.getAnnotationLength());
                out.write(btx.extractAnnotation());
                out.writeInt(btx.getBlockNumber());
                out.writeInt(btx.getTransactionID());
            }
        }
    }

    static final int getRecordLength(BlockTransaction btx) {
        int n = btx.getAnnotationLength();
        return n > 0 ? 10 + n : 0;
    }
}



