package freenet.config;
import freenet.support.Comparable;

public class Option implements Comparable {
        
    String name;
    char abbrev;
    int numArgs;
    Class defaultClass;
    Object defaultValue;
    boolean isExpert = false;
    int sortOrder;

    String argDesc;
    String shortDesc;
    String[] longDesc;
        
    /** Create a new option to register.
     * @param name          The name of the option.
     * @param abbrev        The abbreviated command-line switch.
     * @param numArgs       The number of arguments to read.
     * @param defaultValue  The option's default value.
     * @param sortOrder     Lower value means it is sorted earlier.
     */
    Option(String name, char abbrev, int numArgs, 
           Object defaultValue, int sortOrder) {
        this(name, abbrev, numArgs, defaultValue.getClass(), sortOrder);
        this.defaultValue = defaultValue;
    }

    Option(String name, char abbrev, int numArgs,
           Class defaultClass, int sortOrder) {
        this.name = name;
        this.abbrev = abbrev;
        this.numArgs = numArgs;
        this.sortOrder = sortOrder;
        this.defaultClass = defaultClass;
    }

    Option(String name, char abbrev, int numArgs, 
           Object defaultValue) {
        this(name, abbrev, numArgs, defaultValue, getNum(name));
    }

    Option(String name, char abbrev, int numArgs,
           Class defaultClass) {
        this(name, abbrev, numArgs, defaultClass, getNum(name));
    }

    public final String name() {
        return name;
    }

    public final char abbrev() {
        return abbrev;
    }
        
    public final int numArgs() {
        return numArgs;
    }

    public final Object defaultValue() {
        return defaultValue;
    }

    public final Class defaultClass() {
        return defaultClass;
    }


    public final int compareTo(Object o) {
        int oso = ((Option) o).sortOrder;
        return sortOrder > oso ? 1 : oso == sortOrder ? 0 : -1; 
    }


    // this is just another string hashcode, I just need it to be 
    // consistant.
    private static int getNum(String name) {
        byte[] b = name.getBytes();
        int r = 0, i;
        for (i = b.length - 1; i >= 3 ; i -= 4)
            r ^= b[i] << 24 | b[i-1] << 16 | b[i-2] << 8 | b[i-3];
        switch (i) {
        case 2:
            r ^= b[i-2];
        case 1:
            r ^= b[i-1] << 8; 
        case 0:
            r ^= b[i];
        }
        return r;
    }
}








