/*
  This code is part of fproxy, an HTTP proxy server for Freenet.
  It is distributed under the GNU Public Licence (GPL) version 2.  See
  http://www.gnu.org/ for further details of the GPL.
*/

package freenet.client.http;

import java.util.*;

class ContextManager {
    private static Hashtable table = new Hashtable();
    private static Random random = new Random();

    private final static String makeID() {
        String candidate = null;
        do {
            // REDFLAG: make prettier for URLs ???
            candidate = Long.toString(random.nextLong());
        }
        while (table.get(candidate) != null);
        
        return candidate;
    }

    public final synchronized String add(Object obj) {
        String id = makeID();
        table.put(id, obj);
        System.err.println("ContextManager.add -- [" + id + "," + obj + "]");
        System.err.println("ContextManager.add -- paranoid check: " + lookup(id));
        return id;
    }
    
    public final synchronized void remove(String id) {
        table.remove(id);
    }

    public final synchronized Object lookup(String id) {
        if (id == null) {
            return null;
        }
        return table.get(id);
    }
}

