package freenet.client.events;

import java.io.File;
import freenet.client.*;

/**
 * The TransferStartedEvent is produced when a data transfer
 * is started.  
 *
 * @author oskar
 **/
public class TransferStartedEvent implements ClientEvent {
    public static final int METADATA=0, DATA=1, TOTAL=2;
    public static final int code = 0x80;
    private long[] segmentLengths;

    public TransferStartedEvent(long lengths[]) {
        super();
        this.segmentLengths=lengths;
    }

    public TransferStartedEvent(long len) {
        this(new long[] {-1, -1, len});
    }
        
    public final String getDescription() {
        return "Transfer of " + getLength() + " bytes started.";
    }

    /**
     * Returns the length of data we expect to receive.
     * @return The amount of data to transfer.    
     */
    public final long getLength() {
        return segmentLengths[TOTAL];
    }

    public final long getMetadataLength() {
        return segmentLengths[METADATA];
    }

    public final long getDataLength() {
        return segmentLengths[DATA];
    }

    public final int getCode() {
        return code;
    }
}
