package freenet.client.events;
import freenet.client.ClientEvent;
import freenet.client.Base64;

public class GeneratedKeyPairEvent implements ClientEvent {

    public byte[] privKey;
    public byte[] pubKey;

    public GeneratedKeyPairEvent(byte[] privKey, byte[] pubKey) {
        this.privKey = privKey;
        this.pubKey = pubKey;
    }

    public String getPrivKey() {
        return Base64.encode(privKey);
    }

    public String getPubKey() {
        return Base64.encode(privKey);
    }

    public int getCode() {
        return 668;
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer("Priv. key: ");
        sb.append(Base64.encode(privKey));
        sb.append(" Pub. key: ");
        sb.append(Base64.encode(pubKey));
        return sb.toString();
    }

}
