package freenet.client.cli;
import freenet.config.Params;
import freenet.support.Bucket;
import freenet.support.FileBucketFactory;
import freenet.client.RequestProcess;
import freenet.client.PutRequestProcess;
import freenet.client.FreenetURI;
import freenet.client.metadata.*;
import java.io.IOException;
/**
 * Command pluging for Put (ie InsertRequest).
 *
 * @author oskar
 */
public class PutCommand implements ClientCommand {

    public PutCommand() {
    }

    public String getName() {
        return "put";
    }

    public String getUsage() {
        return "put <URI>";
    }

    public String[] getDescription() {
        return new String[] {
            "Puts a single file into Freenet. If the key is not a CHK and --noredirect",
            "is not given, a redirect to the file will be created with the given URI",
            "pointing to the actual data. If metadata is given through --metadata",
            "and it is a Control document that applies to this URI, it will be",
            "inserted as well, otherwise the metadata will be inserted with the data."
        };
    }

    public int argCount() {
        return 1;
    }

    public RequestProcess getProcess(Params p, Bucket mdata, 
                                     Bucket data) throws CLIException {

        if (p.getNumArgs() < 2)
            throw new CLIException("put command requires URI as argument");
        FreenetURI uri;
        int htl = p.getInt("htl");
        Metadata metadata = null;
        try {
           uri = new FreenetURI(p.getArg(1));
           if (mdata != null)
               metadata = new Metadata(mdata.getInputStream());
        } catch (java.net.MalformedURLException e) {
            throw new CLIException("Malformed URI: " + e);
        } catch (IOException e) {
            e.printStackTrace();
            throw new CLIException("IOException reading metadata: " +
                                   e);
        } catch (InvalidPartException e) {
            throw new CLIException("Invalid part in metadata: " + 
                                   e);
        }
        System.err.println("LALA: " + metadata);
        if (!uri.getKeyType().equals("CHK") && 
            p.getParam("noredirect") == null) {

            try {
                DocumentCommand redirect = new DocumentCommand(metadata);
                redirect.addPart(new Redirect(new FreenetURI("CHK@")));
                metadata = new Metadata();
                metadata.addCommand(redirect);
            } catch (java.net.MalformedURLException e) {
                //            e.printStackTrace();
                throw new CLIException("Exception creating redirect: " +
                                       e);
            } catch (InvalidPartException e) {
                throw new CLIException("Invalid part when creating redirect: "
                                       + e);
            }
        }
        if (p.getParam("dontGuessType") == null) {
            String type = MimeTypeUtils.getExtType(data.getName());
            //System.err.println("CONTENT TYPE: " + type);
            try {
                if (type != null) {
                    if (metadata == null)
                        metadata = new Metadata();
                    DocumentCommand mdc = metadata.getDefaultDocument();
                    if (mdc == null) {
                        mdc = new DocumentCommand((Metadata) null);
                        metadata.addDocument(mdc);
                    }
                    mdc.addPart(new InfoPart("file", type));
                }
            } catch (InvalidPartException e) {
                throw new CLIException("Croaked when adding Content-type: " +
                                       e);
            }
        }

        return new PutRequestProcess(uri, htl, p.getString("cipher"),
                                     metadata, data, new FileBucketFactory(), 
                                     0, true);
    }

    public boolean takesData() {
        return true;
    }

    public boolean givesData() {
        return false;
    }

}
