package freenet;

import java.io.IOException;

public abstract class Address extends AddressBase {

    protected Address(Transport t) {
        super(t);
    }

    /**
     * Connects to this Address.
     * @return  The new Connection.
     */
    public abstract Connection connect() throws ConnectFailedException;

    /**
     * Returns the part of this address that differentiates several nodes
     * on the same entity on the network.
     **/
    public abstract ListeningAddress listenPart();

    /**
     * Checks if two addresses share identity and reside on the same 
     * entity (host) on the network.
     * In other words, if only the part described by ListeningAddress differs.
     **/
    public abstract boolean equalsHost(Object o);

}




