#import "InstallerSDL.h"
#import "InstallerController.h"
#import "InstallerTools.h"

extern BOOL lockedComponents;

@implementation InstallerSDL

- (IBAction)choiceChanged:(id)sender
{
	[controller updateTotalDownload];
}

- (NSString *)destinationPath
{
	return [componentsPath stringByAppendingString:kSDLPackageName];
}

- (NSURL *)downloadURL
{
	if (!alreadyDownloaded && [radios selectedRow] == 0)
		return [NSURL URLWithString:kSDLDownloadURL];
	
	return NULL;
}

- (int)downloadSize
{
	if (!alreadyDownloaded && [radios selectedRow] == 0)
		return kSDLPackageSize;
		
	return 0;
}

- (BOOL)exitReminder
{
	return ([radios selectedRow] == 0);
}

- (BOOL)expand
{
	// If requested extract the SDL package
	if ([radios selectedRow] == 0) {
		[fileManager copyPath:[componentsPath stringByAppendingString:kSDLPackageName] toPath:[temporaryPath stringByAppendingString:@"SDL.pkg.tar.gz"] handler:nil];
		[[controller tools] gunzip:[temporaryPath stringByAppendingString:@"SDL.pkg.tar.gz"]];
		[[controller tools] tar:[temporaryPath stringByAppendingString:@"SDL.pkg.tar"] destination:temporaryPath];
		[fileManager removeFileAtPath:[temporaryPath stringByAppendingString:@"SDL.pkg.tar"] handler:nil];
	}
	
	return YES;
}

- (BOOL)prepare
{
	// Remove any existing temporary files
	if ([fileManager fileExistsAtPath:[temporaryPath stringByAppendingString:@"SDL.pkg.tar.gz"]])
		[fileManager removeFileAtPath:[temporaryPath stringByAppendingString:@"SDL.pkg.tar.gz"] handler:nil];
	if ([fileManager fileExistsAtPath:[temporaryPath stringByAppendingString:@"SDL.pkg.tar"]])
		[fileManager removeFileAtPath:[temporaryPath stringByAppendingString:@"SDL.pkg.tar"] handler:nil];
	if ([fileManager fileExistsAtPath:[temporaryPath stringByAppendingString:@"SDL.pkg"]])
		[fileManager removeFileAtPath:[temporaryPath stringByAppendingString:@"SDL.pkg"] handler:nil];		
	
	return YES;
}

- (void)launch
{
	// If requested launch the SDL installer
	if ([radios selectedRow] == 0) {
		[[NSWorkspace sharedWorkspace] openTempFile:[temporaryPath stringByAppendingString:@"SDL.pkg"]];
	}
}

- (void)setup
{
	BOOL doesExist, versionOk;
	NSString *versionString, *tempPath;
	
	// Search for the compressed package in the "Components" folder
	tempPath = [componentsPath stringByAppendingString:kSDLPackageName];
	doesExist = [fileManager fileExistsAtPath:tempPath];
	if (doesExist) {
		[[radios cellAtRow:0 column:0] setTitle:@"I wish to install the SDL libraries provided"];
		[radios setEnabled:NO];
		[radios selectCellAtRow:0 column:0];
		alreadyDownloaded = YES;
	}
	else {
		[[radios cellAtRow:0 column:0] setTitle:@"I wish to download and install the SDL libraries"];
		alreadyDownloaded = NO;
		if (lockedComponents) {
			[radios setEnabled:NO];
			[radios selectCellAtRow:1 column:0];
		}
	}
	
	// Search for SDL.framework in the home directory and then in the root directory
	tempPath = [NSHomeDirectory() stringByAppendingString:@"/Library/Frameworks/SDL.framework"];
	doesExist = [fileManager fileExistsAtPath:tempPath];
	if (!doesExist) {
		tempPath = [NSString stringWithString:@"/Library/Frameworks/SDL.framework"];
		doesExist = [fileManager fileExistsAtPath:tempPath];
	}
	
	// If we find it check out the version
	if (doesExist) {
		versionString = [[NSDictionary dictionaryWithContentsOfFile:[tempPath stringByAppendingString:@"/Resources/Info.plist"]] objectForKey:@"CFBundleVersion"];
		
		// Check each part of the version
		versionOk = NO;
		if ([[[versionString componentsSeparatedByString:@"."] objectAtIndex:0] intValue] > 1) 
			versionOk = YES;
		if ([[[versionString componentsSeparatedByString:@"."] objectAtIndex:0] intValue] == 1  && [[[versionString componentsSeparatedByString:@"."] objectAtIndex:1] intValue] > 2) 
			versionOk = YES;
		if ([[[versionString componentsSeparatedByString:@"."] objectAtIndex:0] intValue] == 1  && [[[versionString componentsSeparatedByString:@"."] objectAtIndex:1] intValue] == 2 && [[[versionString componentsSeparatedByString:@"."] objectAtIndex:2] intValue] >= 3) 
			versionOk = YES;

		// And make changes as appropriate
		if (versionOk) {
			[label setStringValue:@"SDL Libraries 1.2.3 or later: Installed"];
			[radios setEnabled:NO];
			[radios selectCellAtRow:1 column:0];
		}
		else {
			[label setStringValue:@"SDL Libraries 1.2.3 or later: Out-of-Date"];
		}
		
	}
}

@end
