#import "InstallerMusic.h"
#import "InstallerController.h"
#import "InstallerTools.h"

extern void musicconfig(char *musicDir, char *titleSong, char *songDir);

extern BOOL lockedComponents;

@implementation InstallerMusic

- (IBAction)choiceChanged:(id)sender
{
	[controller updateTotalDownload];
}

- (void)configure
{
	NSString *tempString;
	
	// Configure appropriately
	if ([radios selectedRow] == 1) {
		tempString = [[controller destinationPath] stringByAppendingString:@"/FreeCraft.app/Contents/Resources/data/music/"];
		/*
		[fileManager movePath:[tempString stringByAppendingString:@"Matthew_T._Yankovich--_Twilight_March.ogg"] toPath:[tempString stringByAppendingString:@"title.ogg"] handler:nil];
		[fileManager movePath:[tempString stringByAppendingString:@"Matthew_T._Yankovich--_Midnight_Shadows.ogg"] toPath:[tempString stringByAppendingString:@"song1.ogg"] handler:nil];
		[fileManager movePath:[tempString stringByAppendingString:@"Matthew_T._Yankovich--_Wind_Wraith.ogg"] toPath:[tempString stringByAppendingString:@"song2.ogg"] handler:nil];
		[fileManager movePath:[tempString stringByAppendingString:@"Olech_Kaczanowski_-_For_Honour_And_Glory160.ogg"] toPath:[tempString stringByAppendingString:@"song3.ogg"] handler:nil];
		*/
		musicconfig((char *)[[[controller destinationPath] stringByAppendingString:@"/FreeCraft.app/Contents/Resources/data/ccl"] cString], "music/Matthew_T._Yankovich--_Twilight_March.ogg", NULL);
	}
}

- (NSString *)destinationPath
{
	return [componentsPath stringByAppendingString:kMusicPackageName];
}

- (NSURL *)downloadURL
{
	if (!alreadyDownloaded && [radios selectedRow] == 1)
		return [NSURL URLWithString:kMusicDownloadURL];
	
	return NULL;
}

- (int)downloadSize
{
	if (!alreadyDownloaded && [radios selectedRow] == 1)
		return kMusicPackageSize;
		
	return 0;
}

- (BOOL)expand
{
	// If we have enhanced music expand it into place
	if ([radios selectedRow] == 1) {
		[fileManager copyPath:[componentsPath stringByAppendingString:kMusicPackageName] toPath:[temporaryPath stringByAppendingString:@"music.tar.gz"] handler:nil];
		[[controller tools] gunzip:[temporaryPath stringByAppendingString:@"music.tar.gz"]];
		[[controller tools] tar:[temporaryPath stringByAppendingString:@"music.tar"] destination:temporaryPath];
		[fileManager removeFileAtPath:[[controller destinationPath] stringByAppendingString:@"/FreeCraft.app/Contents/Resources/data/music"] handler:nil];
		[fileManager movePath:[temporaryPath stringByAppendingString:@"data/music"] toPath:[[controller destinationPath] stringByAppendingString:@"/FreeCraft.app/Contents/Resources/data/music"] handler:nil];
		[fileManager removeFileAtPath:[temporaryPath stringByAppendingString:@"music.tar"] handler:nil];
		[fileManager removeFileAtPath:[temporaryPath stringByAppendingString:@"data"] handler:nil];
	}
	
	return YES;
}

- (BOOL)prepare
{
	NSOpenPanel *openPanel = [NSOpenPanel openPanel];
	NSString *tempPath;
	BOOL success = NO;
	
	// Remove any existing temporary files
	if ([fileManager fileExistsAtPath:[temporaryPath stringByAppendingString:@"music.tar.gz"]])
		[fileManager removeFileAtPath:[temporaryPath stringByAppendingString:@"music.tar.gz"] handler:nil];
	if ([fileManager fileExistsAtPath:[temporaryPath stringByAppendingString:@"music.tar"]])
		[fileManager removeFileAtPath:[temporaryPath stringByAppendingString:@"music.tar"] handler:nil];
	if ([fileManager fileExistsAtPath:[temporaryPath stringByAppendingString:@"data"]])
		[fileManager removeFileAtPath:[temporaryPath stringByAppendingString:@"data"] handler:nil];
	
	// If no further preparation is necessary leave
	if ([radios selectedRow] == 0 || [radios selectedRow] == 1)
		return YES;

	// Otherwise, setup the selection panel
	[openPanel setCanChooseDirectories:YES];
	[openPanel setCanChooseFiles:NO];
	[openPanel setAllowsMultipleSelection:NO];
	[openPanel setPrompt:@"Select"];
	[openPanel setTitle:@"Select Music"];
	
	// Run the selection panel
	if ([openPanel runModalForTypes:NULL] == NSOKButton) {
		tempPath = [[openPanel filenames] objectAtIndex:0];
		
	}

	return success;
}

- (void)setup
{
	BOOL doesExist;
	NSString *tempPath;
	
	// Search for the compressed package in the "Components" folder
	tempPath = [componentsPath stringByAppendingString:kMusicPackageName];
	doesExist = [fileManager fileExistsAtPath:tempPath];
	if (doesExist) {
		[[radios cellAtRow:0 column:0] setTitle:@"I wish to use the low-quality \"mod\" files"];
		[[radios cellAtRow:1 column:0] setTitle:@"I wish to install the enhanced \"ogg\" files provided"];
		[radios selectCellAtRow:1 column:0];
		alreadyDownloaded = YES;
	}
	else {
		[[radios cellAtRow:0 column:0] setTitle:@"I wish to use the low-quality \"mod\" files (no extra download)"];
		[[radios cellAtRow:1 column:0] setTitle:@"I wish to download and install the enhanced \"ogg\" files"];
		alreadyDownloaded = NO;
		if (lockedComponents) {
			[[radios cellAtRow:1 column:0] setEnabled:NO];
			[radios selectCellAtRow:0 column:0];
		}
	}
}

@end
