/*	
	AutoCL.h

	AutoCL allows the user to specify a command line through a user-friendly interface
	it will then return that command line for the application until it is next changed.
	The command line is stored on disk so that it persists after exit.
	
	Licensed under the GNU General Public License
*/

#import <Cocoa/Cocoa.h>

#define kOriginalDefaultCL		@""

@interface AutoCL : NSObject
{

	// The NSTextField containing be the command line
    IBOutlet id clInput;
	
	// The panel displaying the NSTextField
    IBOutlet id clPanel;
	
}

// Display the user interface for editing the command line
- (void)editCL:(id)sender;

// Upon return the parameters argc and argv contain the arguments last specified by the user.
// "argv" should be a pointer to a NULL pointer, upon return it will be filled, it is the client's responsibility to free.
- (void)updateArguments;

// Called by a button to put the command line into action
- (IBAction)commitCL:(id)sender;

// Called by a button to revert the command line to that specified by kOriginalDefaultCL (see above)
- (IBAction)revertCL:(id)sender;

@end
