/*****************************************************************************
 Freeciv - Copyright (C) 2005 - The Freeciv Project
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include <fc_config.h>
#endif

/* common/scriptcore */
#include "luascript.h"

/* server/scripting */
#include "script_fcdb.h"

#include "api_fcdb_base.h"

/*****************************************************************************
  Return the value for the fcdb setting 'type'.
*****************************************************************************/
const char *api_fcdb_option(lua_State *L, enum fcdb_option_type type)
{
  LUASCRIPT_CHECK_STATE(L, NULL);
  LUASCRIPT_CHECK_ARG(L, fcdb_option_type_is_valid(type), 2,
                      "Invalid Freeciv database option type.", NULL);

  return fcdb_option_get(type);
}
