import com.tildemh.jgwizard.*;
import org.gnu.gtk.*;
import org.gnu.glib.*;
import org.gnu.gtk.event.*;
import java.io.IOException;


/**
 * Page for root directories/files/urls.
 */
public class RootPage extends WizardPage{

	/**
	 * Construct a new root page
	 * @param wizard 
	 * @param parent
	 * @param idStart The start of the resource identifiers for this page. TODO:
	 * document required resources
	 */
	public RootPage(WizardForm wizard, WizardPage parent, String idStart, String settingID){
		super(wizard, parent, DomesdayGUI.messages.getString(idStart+"Title") );
		resource = idStart;
		setting = settingID;
	}

	private String resource;
	private String setting;

	/**
	 * No customisation is done here. We construct the page in the {@link
	 * #preShow()} method.
	 */
	protected void customise(){
		// We'll do all the work in the preShow method this time...
	}


	/** The view widget */
	private TreeView view;
	/** Data store */
	private ListStore store;
	/** Column for displaying the data */
	private TreeViewColumn column;
	/** renderer for the strings */
	private CellRendererText renderer;	


	/**
	 * Constructs the contents of the page.
	 */
	protected void preShow(){
		System.out.println("root page preshow.");

		/** Stores the content of the page, to be displayed on the output. */
		VBox mainVBox = new VBox(false, 5);

		Label head = new Label( DomesdayGUI.messages.getString(resource+"Head") );
		head.setLineWrap(true);
		mainVBox.packStart(head, false, false, 0);

		Label title = new Label( DomesdayGUI.messages.getString( resource+"ListTitle") );
		mainVBox.packStart(title, false, false, 0);

		store = new ListStore( new Type[] {Type.STRING()});
		view = new TreeView(store);
		column = new TreeViewColumn();
		renderer = new CellRendererText();
		renderer.setEditable(true);
		column.packStart(renderer, false);
		column.addAttributeMapping((CellRenderer) renderer, (CellRendererAttribute) CellRendererText.Attribute.TEXT, 0);
		view.appendColumn(column);
		view.setHeadersVisible(false);
		view.getSelection().setMode( SelectionMode.MULTIPLE );

		ScrolledWindow win = new ScrolledWindow(new Adjustment(0,0,100,1,5,5), new Adjustment(0,0,100,1,5,5));
		win.add(view);
		win.setShadowType(ShadowType.IN);
		win.setPolicy(PolicyType.AUTOMATIC, PolicyType.AUTOMATIC);
		mainVBox.packStart(win, true, true, 5);


		HButtonBox bbox = new HButtonBox();
		mainVBox.packStart(bbox, false, false, 0);
		Button rm = new Button( DomesdayGUI.messages.getString("RootRM") );
		bbox.add(rm);
		rm.addListener( new ButtonListener(){
			public void buttonEvent(ButtonEvent event){
				if (event.isOfType(ButtonEvent.Type.CLICK)){
					view.getSelection().forEachSelected( new TreeSelection.ForEach(){
						public void forEach(TreeModel model, TreePath path, TreeIter iter){
							store.removeRow(iter);
						}
					});
				}
			}
		});

		wizard.addHint(rm, new Hint( DomesdayGUI.messages.getString(resource + "RmHint") ) );

			
		Button add = new Button( DomesdayGUI.messages.getString("RootAdd") );
		bbox.add(add);
		add.addListener( new ButtonListener(){
			// TODO: directory/file selection.
			// TODO: make this work also :-)
			public void buttonEvent(ButtonEvent event){
				if (event.isOfType(ButtonEvent.Type.CLICK)){
					TreeIter iter = store.appendRow();
					store.setValue(iter, 0, "hmmm");
					view.activateCell( store.getPath(iter), column);
				}
			}
		});
		wizard.addHint(add, new Hint( DomesdayGUI.messages.getString(resource + "AddHint") ) );

		
				System.out.println("CRTxt handlerbefore");
		crtListener = new CellRendererTextListener(){
			public void CellRendererTextEvent(CellRendererTextEvent event){
				System.out.println("CRTxt handler");
			}
		};
		renderer.addListener( crtListener );
				System.out.println("CRTxt handler after");


		// populate the list with initial settings.
		try{
			String[] roots = DomesdayGUI.project.getArraySetting(setting);
			for( int i =0; i < roots.length; i++){
				TreeIter iter = store.appendRow();
				store.setValue(iter, 0, roots[i]);
			}
		}catch(IllegalVariableException e){
			DomesdayGUI.log.addError(203, "ILLEGAL_VAR_EXCEPTION", new Object[] { e.toString() } );
			e.printStackTrace();
		}

		mainVBox.showAll();
		content = (mainVBox);
	}

	private static CellRendererTextListener crtListener;
}
