;;; If the c::*check-consistency* is enabled the following produce a
;;; warning.

(defun tst ()
  (make-array 5 :element-type t :initial-element nil))

;;; Transformed to the following.
(defun tst2 ()
  (fill
   (the (SIMPLE-ARRAY T (5)) 
	(kernel:ALLOCATE-VECTOR X86:SIMPLE-VECTOR-TYPE 5 (* 5 1)))
   nil))

;;; Simpler example, still gives the warning.
(defun tst3 (x)
  (declare (type (simple-array t (*)) x))
  (fill x nil))

;;; Above expands to the following, although this no longer gives the
;;; warning.
(defun tst4 (x)
  (declare (type (simple-array t (*)) x))
  (do ((i 0 (1+ i)))
      ((= i (length x)) x)
    (declare (type index i))
    (setf (aref x i) nil)))
