/*
 */

#import <Foundation/Foundation.h>

extern NSDictionary	*appDict;

//#define LocalString(dict, key) (([dict objectForKey:key]) ? [dict objectForKey:key] : key)
#define LocalString(table, key) NSLocalizedStringFromTable((key), (table), NULL)

/* used for configuration purposes
 */
#define AppString(a)	(([appDict objectForKey:(a)]) ? [appDict objectForKey:(a)] : (a))
#define AppObject(a)	([appDict objectForKey:(a)])

/* radius for longitude and latitude comparison
 */
#define RADIUS_25KM	0.225
#define RADIUS_50KM	0.45
#define RADIUS_75KM	0.675
#define RADIUS_100KM	0.9

typedef struct _CityData
{
    int	xPixel, yPixel;
    float	longitude, latitude;
} CityData;

typedef struct _StateCoord
{
    int		stateId;
    CityData	city1;
    CityData	city2;
} StateCoord;

/* replace */
id replaceSubString(id string, NSString *from, NSString *to);
id replaceSubStrings(id string, NSArray *fromA, NSArray *toA);

NSString *convertUmlautToHTML(NSString *data);
NSString *convertUmlautFromHTML(NSString *data);
//char *appName(void);

/* geography
 */
BOOL pixelToDegree(int xPixel, int yPixel, int landId, float *longitude, float *latitude);
const char *buildSwitch(const char *str, int i);
