
#import "VHFGenericRecord.h"
#import "common.h"

static NSString *calendarFormat = @"%d.%m.%Y";


@interface VHFGenericRecord(PrivateMethods)
@end

@implementation VHFGenericRecord

+ record
{
    return [[self alloc] autorelease];
}

+ (void)setCalendarFormat:(NSString*)format
{
    calendarFormat = [format retain];
}

- (NSDictionary*)dictionary
{
    return dictionary;
}

- (VHFGenericRecord*)copyWithPrimaryKey:(NSDictionary*)dict context:(EOEditingContext*)editingContext
{
    EOEntity		*myEntity = [self entity];
    VHFGenericRecord	*copy;
    NSEnumerator	*enumerator = [dict keyEnumerator];
    id			key;

    copy = [[[[self class] alloc] initWithEditingContext:editingContext classDescription:[myEntity classDescriptionForInstances] globalID:[myEntity globalIDForRow:nil]] autorelease];
    [copy takeValuesFromDictionary:[self dictionary]];
    while( key = [enumerator nextObject] )
        [copy takeValue:[dict objectForKey:key] forKey:key];
    [editingContext insertObject:copy];

    return copy;
}

/* correct umlaut
 */
- (void)takeValue:obj forKey:(NSString*)key
{
    if( !obj )
        obj = [EONull null];
    [super takeValue:obj forKey:key];
}

/* correct umlaut
 */
- (void)takeHTMLValue:obj forKey:(NSString*)key
{
    if( [obj isKindOfClass:[NSString class]] )
        obj = convertUmlautFromHTML(obj);
    else if( !obj )
        obj = [EONull null];
    [super takeValue:obj forKey:key];
}

/* we want nil instead of an EONull object
 */
- (id)valueForKey:(NSString*)key
{   id	obj;

    obj = [super valueForKey:key];
    if( [obj isKindOfClass:[EONull class]] )
        return nil;
    return obj;
}

- (id)valueForKey:(NSString*)key default:(id)defaultObj
{   id	obj;

    obj = [super valueForKey:key];
    if( !obj || [obj isKindOfClass:[EONull class]] )
        return defaultObj;
    return obj;
}

/* return object, string will be converted to html
 */
- (id)htmlValueForKey:(NSString*)key
{   id	obj;

    obj = [super valueForKey:key];
    if( !obj || [obj isKindOfClass:[EONull class]] )
        return nil;
    if( [obj isKindOfClass:[NSString class]] )
        return convertUmlautToHTML(obj);
    return obj;
}

/* string for specified language (de, gb) or default
 */
- (NSString*)stringForKey:(NSString*)key language:(NSString*)lng
{   NSString	*string = [key stringByAppendingFormat:@"_%@", lng];

    return [self stringForKey:([self valueForKey:string]) ? string : key];
}

/* return string
 */
- (id)stringForKey:(NSString*)key
{   id	obj;

    obj = [super valueForKey:key];
    if( !obj || [obj isKindOfClass:[EONull class]] )
        return @"";
    if( [obj isKindOfClass:[NSNumber class]] )
        return [obj stringValue];
    else if( [obj isKindOfClass:[NSCalendarDate class]] )
        return [obj descriptionWithCalendarFormat:calendarFormat];
    else if( [obj isKindOfClass:[NSDate class]] )
        return [obj description];
    return obj;
}

/* string for specified language (de, gb) or default
 */
- (NSString*)htmlStringForKey:(NSString*)key language:(NSString*)lng
{   NSString	*string = [key stringByAppendingFormat:@"_%@", lng];

    return [self htmlStringForKey:([self valueForKey:string]) ? string : key];
}

/* return html string
 */
- (NSString*)htmlStringForKey:(NSString*)key
{   id	obj;

    obj = [super valueForKey:key];
    if( !obj || [obj isKindOfClass:[EONull class]] )
        return @"";
    if( [obj isKindOfClass:[NSNumber class]] )
        return [obj stringValue];
    else if( [obj isKindOfClass:[NSCalendarDate class]] )
        return [obj descriptionWithCalendarFormat:calendarFormat];
    else if( [obj isKindOfClass:[NSDate class]] )
        return [obj description];
    return convertUmlautToHTML(obj);
}

/* return string, string will be converted to html
 */
- (id)htmlStringForKey:(NSString*)key default:(id)defaultVal
{   id	obj;

    obj = [super valueForKey:key];
    if( !obj || [obj isKindOfClass:[EONull class]] )
        return defaultVal;
    if( [obj isKindOfClass:[NSString class]] )
        return convertUmlautToHTML(obj);
    if( [obj isKindOfClass:[NSNumber class]] )
        return [obj stringValue];
    else if( [obj isKindOfClass:[NSCalendarDate class]] )
        return [obj descriptionWithCalendarFormat:calendarFormat];
    else if( [obj isKindOfClass:[NSDate class]] )
        return [obj description];
    return convertUmlautToHTML(obj);
}

/* return string
 */
- (id)stringForKey:(NSString*)key default:(NSString*)defaultObj
{   id	obj;

    obj = [super valueForKey:key];
    if( !obj || [obj isKindOfClass:[EONull class]] )
        return defaultObj;
    if( [obj isKindOfClass:[NSNumber class]] )
        return [obj stringValue];
    else if( [obj isKindOfClass:[NSCalendarDate class]] )
        return [obj descriptionWithCalendarFormat:calendarFormat];
    else if( [obj isKindOfClass:[NSDate class]] )
        return [obj description];
    return obj;
}

- (int)intForKey:(NSString*)key
{   id	obj;

    obj = [super valueForKey:key];
    if( !obj || [obj isKindOfClass:[EONull class]] )
        return 0;
    if( ![obj respondsToSelector:@selector(intValue)] )
    {   NSLog(@"'%@' does not respond to 'intValue'", obj);
        return 0;
    }
    return [obj intValue];
}

- (float)floatForKey:(NSString*)key
{   id	obj;

    obj = [super valueForKey:key];
    if( !obj || [obj isKindOfClass:[EONull class]] )
        return 0.0;
    if( ![obj respondsToSelector:@selector(floatValue)] )
    {   NSLog(@"'%@' does not respond to 'floatValue'", obj);
        return 0.0;
    }
    return [obj floatValue];
}

- (VHFGenericRecord*)toPhoto
{   //VHFGenericRecord	*photo;

    if( [[self valueForKey:@"toPhoto"] count] )
        return [[self valueForKey:@"toPhoto"] objectAtIndex:0];
    return nil;
#if 0
    NS_DURING
        /* If the receiver is a fault, sending it a self message
         * attempts to resolve it. If the corresponding row doesn't
         * exist in the database, an exception is raised.
         */
        photo = [[self valueForKey:@"toPhoto"] self];
    NS_HANDLER
        photo = nil;
    NS_ENDHANDLER

    return photo;
#endif
}
- (NSData*)photo
{
    return [[self toPhoto] valueForKey:@"photo"];
}

/* created: 13.04.97
 * lproj = "/German.lproj" etc.
 */
- (NSString*)htmlState:(NSString*)lproj
{
    return convertUmlautToHTML([self state:lproj]);
}

/*
 * modified: 09.09.97
 *
 * we support both:
 * "49" = ("Deutschland", "D-");
 * "49" = "Deutschland";
 */
- (NSString*)state:(NSString*)lproj
{   NSString		*path = [NSString stringWithFormat:@"%@/%@/state.dict", [[NSBundle mainBundle] resourcePath], lproj];
    NSDictionary	*stateDict = [NSDictionary dictionaryWithContentsOfFile:path];
    NSNumber		*stateId;
    id			state;

    if( !stateDict )
    {   NSLog(@"state: 'state.dict' expected in path '%@'", path);
        return @"-";
    }
    if( !(stateId=[self valueForKey:@"state_id"]) )
    {   NSLog(@"state: 'state_id' expected in entity '%@'", [[self entity] name]);
        return @"";
    }
    if( !(state = [stateDict objectForKey:[stateId stringValue]]) )
    {   NSLog(@"state: state  '%@' expected in state.dict", stateId);
        return nil;
    }
    if( [state isKindOfClass:[NSArray class]] )
        return [state objectAtIndex:0];
    return state;
}

/* created:  14.04.97
 * modified: 07.08.97 09.09.97
 *
 * "49" = ("Deutschland", "D-");
 */
- (NSString*)statePostal:(NSString*)lproj
{   NSString		*path = [NSString stringWithFormat:@"%@/%@/state.dict", [[NSBundle mainBundle] resourcePath], lproj];
    NSDictionary	*stateDict = [NSDictionary dictionaryWithContentsOfFile:path];
    NSNumber		*stateId;
    id			state;

    if( !stateDict )
    {   NSLog(@"state: 'state.dict' expected in path '%@'", path);
        return nil;
    }
    if( !(stateId=[self valueForKey:@"state_id"]) )
    {   NSLog(@"state: 'state_id' expected in entity '%@'", [[self entity] name]);
        return nil;
    }
    if( !(state = [stateDict objectForKey:[stateId stringValue]]) )
    {   NSLog(@"state: state  '%@' expected in state.dict", stateId);
        return nil;
    }
    if( [state isKindOfClass:[NSArray class]] && [state count] > 1 )
        return [state objectAtIndex:1];
    return nil;
}

@end
