%define name	Bastille
%define version	1.2.0
%define release	1.0mdk


Summary:	Bastille tightens security on a Mandrake or Red Hat Linux system.
Name:		%{name}
Version:	%{version}
Release:	%{release}
Source0:	http://www.bastille-linux.org/jay/%{name}-%{version}.tar.bz2
Copyright:	GPL
Requires:	Bastille-perl-UI-module
Group:		System/Configuration/Other
BuildRoot:	%{_tmppath}/%{name}-buildroot
Prefix:		%{_prefix}
BuildArchitectures: noarch

%description
Bastille Linux is a security hardening program for Mandrake and Red Hat Linux.
If run in the preferred Interactive mode, it can teach you a good deal about 
Security while personalizing your system security state.  If run in the 
quicker Automated mode, it can quickly tigten your machine, but not nearly
as effectively (since user/sysadmin education is an important step!)

To run:

   Best:        InteractiveBastille
   Good:        BastilleChooser  (under X)
   		AutomatedBastille (under Curses)  [deprecated]

%package Curses-module
Summary:	This module provides Bastille-perl-UI-module to Bastille Linux. 
Provides:	Bastille-perl-UI-module
Requires:	perl-Curses Bastille
Group:		System/Configuration/Other

%description Curses-module
Bastille Linux requires either Perl-Tk, used for its X interface, or
Perl-Curses, used for its Curses-based terminal interface.  This module
provides the requirement for Perl-Curses.

%package Tk-module
Summary:	This module provides Bastille-perl-UI-module to Bastille Linux.
Provides:	Bastille-perl-UI-module
Requires:	perl-Tk Bastille
Group:		System/Configuration/Other

%description Tk-module
Bastille Linux requires either Perl-Tk, used for its X interface, or
Perl-Curses, used for its Curses-based terminal interface.  This module
provides the requirement for Perl-Tk.

%package Chooser
Summary:        BastilleChooser helps a new user choose a pre-written security configuration.
Requires:       perl-GTK Bastille
Group:          System/Configuration/Other

%description Chooser
Bastille Linux can be run in one of two modes: Interactive or Automated.
Interactive allows you to fine-tune your system security and teaches you
about security, so as to help you make the best choices.  The other mode
allows you to choose a pre-written configuration, by answering 1-3 questions.
While we recommend the former, this latter option is much better than not
running Bastille at all.

%prep
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
%setup -n Bastille
#%patch -p0

%build

%install
#cd /home/jay/rpm/SOURCES/Bastille
mkdir -p $RPM_BUILD_ROOT%{_sbindir}
mkdir -p $RPM_BUILD_ROOT%{_libdir}/perl5/site_perl/Curses
mkdir -p $RPM_BUILD_ROOT%{_libdir}/Bastille
mkdir -p $RPM_BUILD_ROOT%{_datadir}/Bastille
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/Bastille

cp AutomatedBastille $RPM_BUILD_ROOT%{_sbindir}
cp BastilleChooser $RPM_BUILD_ROOT%{_sbindir}
cp BastilleBackEnd $RPM_BUILD_ROOT%{_sbindir}
cp Bastille_Curses.pm $RPM_BUILD_ROOT%{_libdir}/perl5/site_perl
cp Bastille_Tk.pm $RPM_BUILD_ROOT%{_libdir}/perl5/site_perl
cp Curses/Widgets.pm $RPM_BUILD_ROOT%{_libdir}/perl5/site_perl/Curses
cp ServerLax.config $RPM_BUILD_ROOT%{_datadir}/Bastille
cp ServerModerate.config $RPM_BUILD_ROOT%{_datadir}/Bastille
cp ServerParanoia.config $RPM_BUILD_ROOT%{_datadir}/Bastille
cp WorkstationLax.config $RPM_BUILD_ROOT%{_datadir}/Bastille
cp WorkstationModerate.config $RPM_BUILD_ROOT%{_datadir}/Bastille
cp WorkstationParanoia.config $RPM_BUILD_ROOT%{_datadir}/Bastille
#cp Default_Workstation $RPM_BUILD_ROOT%{_datadir}/Bastille
#cp Default_Workstation_plus_Firewall $RPM_BUILD_ROOT%{_datadir}/Bastille
cp mandrake_perm.[012345] $RPM_BUILD_ROOT%{_datadir}/Bastille
#cp mandrake_server.[45] $RPM_BUILD_ROOT%{_datadir}/Bastille
cp InteractiveBastille $RPM_BUILD_ROOT%{_sbindir}
cp find_bastille_affected_files.pl $RPM_BUILD_ROOT%{_datadir}/Bastille
cp Questions.txt $RPM_BUILD_ROOT%{_datadir}/Bastille
cp Credits $RPM_BUILD_ROOT%{_datadir}/Bastille
cp UndoBastille $RPM_BUILD_ROOT%{_sbindir}
cp bastille-firewall $RPM_BUILD_ROOT%{_datadir}/Bastille
cp bastille-ipchains $RPM_BUILD_ROOT%{_datadir}/Bastille
cp bastille-netfilter $RPM_BUILD_ROOT%{_datadir}/Bastille
cp bastille-firewall-early.sh $RPM_BUILD_ROOT%{_sysconfdir}/Bastille
cp bastille-firewall-reset $RPM_BUILD_ROOT%{_datadir}/Bastille
cp bastille-firewall-schedule $RPM_BUILD_ROOT%{_datadir}/Bastille 
cp bastille-tmpdir-defense.sh $RPM_BUILD_ROOT%{_datadir}/Bastille 
cp bastille-tmpdir.csh $RPM_BUILD_ROOT%{_datadir}/Bastille
cp bastille-tmpdir.sh $RPM_BUILD_ROOT%{_datadir}/Bastille
cp bastille-firewall.cfg $RPM_BUILD_ROOT%{_datadir}/Bastille
cp ifup-local $RPM_BUILD_ROOT%{_datadir}/Bastille
cp hosts.allow $RPM_BUILD_ROOT%{_datadir}/Bastille
cp Bastille/AccountSecurity.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/Apache.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/API.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/BootSecurity.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/ConfigureMiscPAM.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/DisableUserTools.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/DNS.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/FilePermissions.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/FTP.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/Firewall.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/Logging.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/MiscellaneousDaemons.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/Printing.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/RemoteAccess.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/SecureInetd.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/Sendmail.pm $RPM_BUILD_ROOT%{_libdir}/Bastille
cp Bastille/TMPDIR.pm $RPM_BUILD_ROOT%{_libdir}/Bastille

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
rm -fr $RPM_BUILD_ROOT/%{name}

%preun
rm -f /etc/Bastille/bastille-firewall-early.sh.bsave
[ -e /etc/Bastille/bastille-firewall.cfg ] && cp -p \
/etc/Bastille/bastille-firewall-early.sh \
/etc/Bastille/bastille-firewall-early.sh.bsave
 
%postun
[ -e /etc/Bastille/bastille-firewall-early.sh.bsave -a ! -e \
/etc/Bastille/bastille-firewall-early.sh ] && mv \
/etc/Bastille/bastille-firewall-early.sh.bsave \
/etc/Bastille/bastille-firewall-early.sh
[ -e /etc/Bastille/bastille-firewall-early.sh.bsave ] && rm -f \
/etc/Bastille/bastille-firewall-early.sh.bsave


%files
%defattr(-,root,root,0755)
%doc README docs/readme.automate docs/readme.ftp docs/readme.interfaces docs/readme.patch COPYING Credits Changelog VERSION 
%defattr(-,root,root,0600)
%attr(0700,root,root)  %{_sbindir}/AutomatedBastille
#%attr(0700,root,root)  %{_sbindir}/BastilleChooser
%attr(0700,root,root)  %{_sbindir}/BastilleBackEnd 
%{_datadir}/Bastille/find_bastille_affected_files.pl
%{_datadir}/Bastille/ServerLax.config
%{_datadir}/Bastille/ServerModerate.config
%{_datadir}/Bastille/ServerParanoia.config
%{_datadir}/Bastille/WorkstationLax.config
%{_datadir}/Bastille/WorkstationModerate.config
%{_datadir}/Bastille/WorkstationParanoia.config
#%{_datadir}/Bastille/Default_Workstation
#%{_datadir}/Bastille/Default_Workstation_plus_Firewall
%{_datadir}/Bastille/mandrake_perm.0
%{_datadir}/Bastille/mandrake_perm.1
%{_datadir}/Bastille/mandrake_perm.2
%{_datadir}/Bastille/mandrake_perm.3
%{_datadir}/Bastille/mandrake_perm.4
%{_datadir}/Bastille/mandrake_perm.5
#%{_datadir}/Bastille/mandrake_server.4
#%{_datadir}/Bastille/mandrake_server.5
%attr(0700,root,root)  %{_sbindir}/InteractiveBastille
%{_datadir}/Bastille/Questions.txt
%{_datadir}/Bastille/Credits
%attr(0700,root,root)  %{_sbindir}/UndoBastille
%{_datadir}/Bastille/bastille-firewall-reset
%{_datadir}/Bastille/bastille-firewall-schedule
%{_datadir}/Bastille/bastille-tmpdir-defense.sh
%{_datadir}/Bastille/bastille-tmpdir.csh
%{_datadir}/Bastille/bastille-tmpdir.sh
%{_datadir}/Bastille/ifup-local
%{_datadir}/Bastille/hosts.allow
%{_datadir}/Bastille/bastille-firewall
%{_datadir}/Bastille/bastille-firewall.cfg
%{_datadir}/Bastille/bastille-ipchains
%attr(0700,root,root)  %{_sysconfdir}/Bastille/bastille-firewall-early.sh
%{_datadir}/Bastille/bastille-netfilter 
%attr(0700,root,root)  %dir %{_libdir}/Bastille
%attr(0700,root,root)  %dir %{_sysconfdir}/Bastille
%{_libdir}/Bastille/API.pm
%{_libdir}/Bastille/AccountSecurity.pm
%{_libdir}/Bastille/Apache.pm
%{_libdir}/Bastille/BootSecurity.pm
%{_libdir}/Bastille/ConfigureMiscPAM.pm
%{_libdir}/Bastille/DNS.pm
%{_libdir}/Bastille/DisableUserTools.pm
%{_libdir}/Bastille/FTP.pm
%{_libdir}/Bastille/FilePermissions.pm
%{_libdir}/Bastille/Firewall.pm
%{_libdir}/Bastille/Logging.pm
%{_libdir}/Bastille/MiscellaneousDaemons.pm
%{_libdir}/Bastille/Printing.pm  
%{_libdir}/Bastille/RemoteAccess.pm 
%{_libdir}/Bastille/SecureInetd.pm
%{_libdir}/Bastille/Sendmail.pm
%{_libdir}/Bastille/TMPDIR.pm

%files Tk-module
%defattr(-,root,root,0755)
%{_libdir}/perl5/site_perl/Bastille_Tk.pm

%files Curses-module
%defattr(-,root,root,0755)
%{_libdir}/perl5/site_perl/Bastille_Curses.pm
%{_libdir}/perl5/site_perl/Curses/Widgets.pm

%files Chooser
%defattr(-,root,root,0755)
%attr(0700,root,root)  %{_sbindir}/BastilleChooser


%changelog
* Tue Jun 12 2001 Jay Beale <jay@bastille-linux.org> 1.2.0-1.0mdk
-  fixed libwrap problem to accomodate Red Hat 7.x

* Wed Jun 6 2001 Jay Beale <jay@bastille-linux.org> 1.2.0-0.2mdk
-  small bugfix: a run-twice bug
-  added preun and postun section to spec file

* Wed May 9 2001 Jay Beale <jay@bastille-linux.org> 1.2.0-0.1mdk
-  rc6 was stable -- releasing as 1.2.0!
-  Note: previous versions were stable for MDK8.0 -- most corrections were
         specific to Red Hat

* Mon Apr 30 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.rc6-0.1mdk
-  Minor tweak in firewall to get Internal services working properly under
   2.4 kernel.
-  Fixed mknod to do correct return value.

* Mon Apr 23 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.rc5-0.1mdk
-  Additional Red Hat fix for xinetd
-  xinetd/tcpd interaction tweaked

* Fri Apr 20 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.rc4-0.1mdk
-  Added Red Hat 7.1 fixes

* Tue Apr 09 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.rc3-0.1mdk
-  Integrated PeterW's additional "play nice with drakgw" code
-  Urged PeterW and gc@mandrakesoft.com to get some sleep.

* Tue Apr 09 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.rc2-0.4mdk
-  Integrated code so Bastille plays nice with drakgw under 2.2 kernel

* Tue Apr 09 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.rc2-0.3mdk
-  Moved bastille-firewall-early.sh to /etc/Bastille
-  Fixed minor warning:  pop-3 isn't in /etc/services - change to pop3

* Tue Apr 09 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.rc2-0.2mdk
-  Enhanced bastille firewalling code to cooperate intelligently with
   drakgw's Internet Connection Sharing

* Mon Apr 08 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.rc2-0.1mdk
-  Fixed named bug: we weren't modifying recent distro's init script right.
-  Fixed question flow oversight.
-  Replaced GLOBAL_FILE hash lookup with GLOBAL_DIR in ConfigureMiscPAM
-  Added bastille-firewall to list of init scripts to NOT deactivate

* Fri Apr 05 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.rc1-0.1mdk
-  Added netfilter code to handle NetBIOS cases
-  Fixed an escape bug on an @ sign
-  Implemented SKIP_CHILD label to skip a couple more questions
-  added find_bastille_affected_files.pl investigative script

* Tue Mar 27 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre22-0.3mdk
-  Fixed a stupid bug: we were writing LEVEL_SECURE instead of SECURE_LEVEL.

* Mon Mar 26 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre22-0.2mdk
-  Fixed PATH bug -- do   export PATH=foo
-  Fixed bug in adding the security scripts: added a \n to the end of the
   /etc/crontab lines.
-  fixed logging bug where *.*   /dev/tty12   is appended without a newline.
-  fixed peterw's bastille-tmpdir-defense bugs -- bash2 is incompatible
   with bash 1.14

* Mon Mar 26 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre22-0.1mdk
-  Fixed chkconfig_off to create K__ symlinks in place of the ones that it
   removes.
-  Cleaned up questions.txt, so user is told they can select any umask, in 
   addition to the ones provided my security levels.
-  Fixed stupid bug in Logging.pm :   s/B_append_file/B_append_line/
-  Fixed PATH to include /usr/games and not include quotes.
-  Incremented security level number set by the prewritten configurations,
   such that Lax=2, Moderate=3, Paranoia=4.
-  Fixed all the double quote bugs based on pixel's grep.

* Sun Mar 25 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre21-0.1mdk
-  Modified specfile to place BastilleChooser in separate package.

* Sun Mar 25 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre21-0.1mdk
-  Minor oversight correction -- disallowed root logins via [gkx]dm via PAM.
-  Switched "  into  '  signs in two regeps in BootSecurity.pm,SecureInetd.pm.
-  Fixed requires-bug that was stopping sendmail from getting called.
-  Set the default configurations to not use pam filesize/process number limits.
-  Bugfix: when you wanted root login denied on console, it was allowed and v/v.
-  Fixed quoting bug in /etc/profile PATH-setting :  Mandrake specific
-  Finished adding all new questions to pre-writtens configs/"security levels"

* Fri Mar 23 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre20-0.1mdk
-  Fixed Matt's BastilleChooser bug -- if you selected "lax" then you
   didn't get a configuration written -- totally terminal bug.
-  Fixed Questions.txt bug -- question "foo"!
-  Fixed /etc/securetty bug -- the question was reversed from the
   corresponding action
-  Fixed bug: export SECURELEVEL was only in /etc/profile -- added in
   /etc/zprofile as well.
-  Fixed problem in ServerLax -- some settings were too tight.
-  Fixed problem in ServerLax -- it was set to write LILO changes to disk.
-  Changed method of deactivating telnet+ftp in xinetd.d/ use "disable" lines.
-  Corrected oversight in disabling root tty access -- we now also disable root
   xdm-based login.
-  Removed libsafe question -- libsafe 1.3 would introduce instability because
   of omit-frame-pointer compiler flag and libsafe 2.0 is too new.

* Thu Mar 21 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre19-0.2mdk
-  lots of bugfixes

* Wed Mar 20 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre19-0.1mdk
-  Added syslogging *.* to /dev/tty12, as msec compatibility feature
-  Added PATH adjustments to Bastille, as msec compatibility feature
-  Added export SECURE_LEVEL in /etc/profile, as msec compat feature.
-  Added feature to disable kdm/gdm user listing, as msec compat feature.
-  Added libsafe functionality to maintain compatibility with msec.
-  Moved Curses-specific files into Bastille-Curses-module
-  Moved Tk-specific files into Bastille-Tk-module

* Wed Mar 20 2001 Vincent Danen <vdanen@mandrakesoft.com 1.2.0.pre18-0.3mdk
-  specfile cleanups; macros

* Mon Mar 19 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre18-0.2mdk
-  bugfixes in requirements code

* Sun Mar 18 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre18-0.1mdk
-  added remaining msec functions
-  re-worked inetd/xinetd module
-  more bugfixes

* Sat Mar 17 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre17-0.1mdk
-  added msec fileperms support 
-  cleaned up requires code - several bugfixes
-  more bugfixes
-  enhanced API.pm functions to support globbing

* Tue Mar 13 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre15-0.1mdk
-  added Spong's hack to BastilleChooser to let you specify
   security/paranoia level on the command line.

* Mon Mar 12 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre14-0.1mdk
- Added more pre-written configuration templates
- added Spong's BastilleChooser program to choose/modify the templates based on user input
- added Paul's hack to Curses interface so it reads in previously-written 
  configuration if one exists.

* Sun Mar 11 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre13-0.1mdk
- applied PeterW's "make question pruning optional" patch
- applied a whole lot of other PeterW changes (details coming)

* Sat Mar 10 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre12-0.1mdk
- Fixed requirements bugs
- Updated Questions database: suid questions won't get asked if 
  requisite binaries aren't suid

* Sat Mar 10 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre11-0.1mdk
- Re-worked requirements language

* Wed Feb 21 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre9-0.4mdk
- Fixed stupid date error in spec file

* Wed Feb 21 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre9-0.3mdk
- removed the specs for Bastille-perl-Tk and Bastille-perl-Curses and
  wrote the virtual provide/require rpm The Right Way.

* Wed Feb 21 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre9-0.2mdk
- added a virtual rpm to require perl-Tk OR perl-Curses

* Mon Feb 19 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre9-0.1mdk
- fixed firewall bug by hacking Questions.txt. 

* Sun Feb 18 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre8-0.1mdk
- refixed BastilleBackEnd @INC bug ...
- fixed bug where Bastille fails to properly detect Mandrake and Immunix versions.
  Longstanding, stupid and dependent on ordering. 
- changed API::B_place to suit the new file locations 
- fixed tiny bug in API::B_hash_comment and uncomment.
- updated Pete's scripts, modules and Questions.txt.
- fixed bug where Bastille fails to account for MandrakeSoft's weird naming scheme for
  their distro (Linux Mandrake)
- other misc bugs


* Sun Feb 18 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre7-0.1mdk
- Fixed InteractiveBastille bug
- Forced X (tk) mode on Interface unless user specifically uses -c flag. 
- -c flag on GUI/TUI checks for perl-Curses module.

* Sun Feb 18 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre6-0.1mdk
- Removed .pl's from program names and changed BackEnd script name

* Sun Feb 18 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre5-0.1mdk
- Bugfixes from Keith Buck.
- Changed README to be more appropriate to new system.
- Added PeterW's netfilter script, so bastille-firewall loads the "right"  
  script for the given kernel.
- Fixed AutomatedBastille so it works!

* Tue Feb 15 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre4-0.1mdk
- Added install script (so developers can hack without dealing with RPM's. 
- Added Greg K's diff to support Immunix OS's.
- Altered specfile to not require Curses.  Thus, force people to use X 
  interface for now.


* Tue Feb 15 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre3-0.1mdk
- Added Peter's IPCHAINS compatibility diff, to support 2.4 kernels until we
  get true Netfilter support
  - Added perl-Tk requires code
  - Fixed UndoBastille problems -- it runs now.  Darn it Sweth!!!!

* Mon Feb 14 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre2-0.1mdk
- Fit to RPM, hacked file system locations (1.2.0.pre2)

* Mon Feb 14 2001 Jay Beale <jay@mandrakesoft.com> 1.2.0.pre1-0.1mdk
- Built the first alpha-quality RPM to allow cooker testing.
-
- Bastille Linux's "real" changelog can be found at
-         http://www.bastille-linux.org/Changelog
- 	 
-	 This Changelog is specific to this RPM.

