# Copyright (C) 1999, 2000 Jay Beale
# Licensed under the GNU General Public License


package Bastille::Apache;
use lib "/usr/lib";

use Bastille::API;

@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

# TO DO:
#
# 1. Write ConfigureSSL

#######################################################################
##                              HTTP/APACHE                          ##
#######################################################################

&DeactivateApacheServer;
&LimitListeningInterfaces;
&ChrootApache;
&UpgradeApache;
#&ModifyAccessconf;
#&ConfigureSSL;


sub DeactivateApacheServer {

    if ( &getGlobalConfig("Apache","apacheoff") eq "Y" ) {

	&ActionLog("# sub DeactivateApacheServer\n");

	&B_chkconfig_off ("httpd");

    }

}

sub LimitListeningInterfaces {

    if ((&getGlobalConfig("Apache","bindapachelocal") eq "Y") or (&getGlobalConfig("Apache","bindapachenic") eq "Y")) {
	
	&ActionLog("# sub LimitListeningInterfaces\n");

	# First, figure out which configuration file to modify...
	
	my $httpd_file=&getGlobal('FILE', "httpd.conf");

	# Bind Apache to a particular interface or to the loopback device.

	if (&getGlobalConfig("Apache","bindapachenic") and (&getGlobalConfig("Apache","bindapacheaddress") =~ /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/) ) {
	    my $listen_ip=&getGlobalConfig("Apache","bindapacheaddress");
	    if (! ($listen_ip =~ /\:/) ) {
		# user did not specify port number
		&ErrorLog("Binding Apache to a particular IP address: no port specified, defaulting to :80\n");
		$listen_ip .= ":80";
	    }
	    
	    &B_replace_line($httpd_file,'^\s*Listen\s',"Listen ${listen_ip}\n");
	}
	elsif (&getGlobalConfig("Apache","bindapachelocal") eq "Y") {
	    &B_replace_line($httpd_file,'^\s*Listen\s',"Listen 127.0.0.1:80\n");
	}
	else {
	    &ErrorLog("Some weirdness in trying to limit Apache's listening interfaces.  Probably, you tried to bind Apache to a particular interface, but did not specify a valid interface number...\n");
	}

    }
}

sub ModifyAccessconf {

    if ( (&getGlobalConfig("Apache","symlink") eq "Y") or (&getGlobalConfig("Apache","ssi") eq "Y") or (&getGlobalConfig("Apache","cgi") eq "Y") or (&getGlobalConfig("Apache","apacheindex") eq "Y" ) ) {
	
	&ActionLog("# sub ModifyAccessconf\n");
	# Editting access.conf for safer settings
	
	# Disable FollowSymLinks to prevent users linking world readable/user 
	# readable files to allow viewing/access by the server.
	#
	# Deactivate Server Side includes
	# Deactivate CGI scripts
	# Deactivate generation of indexes for directories that don't have them


	my $access_file = &getGlobal('FILE', "httpd_access.conf");
	my $new_options_line="Options ";

	unless (&getGlobalConfig("Apache","apacheindex") eq "Y") {
	    $new_options_line .= "Indexes ";
	}
	unless (&getGlobalConfig("Apache","ssi") eq "Y" ) {
	    $new_options_line .= "Includes ";
	}
	unless (&getGlobalConfig("Apache","symlink") eq "Y" ) {
	    $new_options_line .= "FollowSymLinks ";
	}
	$new_options_line .= "\n";

	&B_replace_line ($access_file,'^\s*Options\s.*\bIncludes\b',$new_options_line);
	if (&getGlobalConfig("Apache","cgi") eq "Y") {
	    &B_hash_comment_line($access_file,"Options.*ExecCGI");
	}
    }

}
################################################################################
#  &ChrootApache;
#     This subroutine uses the chroot script that comes with Apache 1.3.19
#     or greater.  It makes modifications to httpd.conf so that when
#     Apache starts it will chroot itself into the jail that the above
#     mentions script creates.
#
#     uses B_replace_line B_create_dir B_System B_TODO
###############################################################################
sub ChrootApache {
    &ActionLog("# sub ChrootApache\n");

    if(&getGlobalConfig('Apache','chrootapache') eq "Y"){
	my $exportpath = "export PATH=/usr/bin;";
	&B_System("$exportpath " . &getGlobal('FILE',"apachectl"). " stop","$exportpath " . &getGlobal('FILE',"apachectl"). " start");
	&B_replace_line(&getGlobal('FILE',"httpd.conf"), '^\s*#\s*Chroot' ,
			"Chroot " . &getGlobal('BDIR',"apachejail"));
	if(-d &getGlobal('BDIR',"jail")){
	    &ActionLog("Jail directory already exists. No action taken.\n");
	}
	else{
	    &ActionLog("Jail directory was created.\n");
	    &B_create_dir( &getGlobal('BDIR','jail'));
	}
	    
	if(-d &getGlobal('BDIR',"apachejail")){
	    &ActionLog("Apache jail already exists. No action taken.\n");
	}
	else{
	    &B_System(&getGlobal('BIN',"umask") . " 022; $exportpath " . &getGlobal('FILE',"chroot_os_cp.sh"),
		      &getGlobal('BIN',"echo") . " \"Your Apache Server is now running outside of it's\\n" . 
		      "chroot jail.  You must manually migrate your web applications\\n" .
		      "back to your Apache server's httpd.conf defined location(s).\\n".
		      "After you have completed this, feel free to remove the jail directories\\n" .
		      "from your machine.  Your apache jail directory is located in\\n" . 
		      &getGlobal('BDIR',"jail") . "\\n\" >> " . &getGlobal('BFILE',"TOUNDO"));
	    
	}
	&B_System("$exportpath " . &getGlobal('FILE',"apachectl"). " start","$exportpath " . &getGlobal('FILE',"apachectl"). " stop");
	&ActionLog("Apache is now running in an chroot jail.\n");
	&ActionLog("The jail is located in " . &getGlobal('BDIR',"apachejail") . "\n");


	&B_TODO("APACHE JAIL:\n" . 
		"If some funtionality is not working after\n" . 
		"apache was placed in a chroot jail manual action\n" .
		"is required.  For more information view the\n" .
		"httpd.conf file. It gives additional information\n" .
		"about post chrooting an apache server.\n");
    }
}

################################################################################
#  &UpgradeApache;
#     This subroutine places information in the TODO list on how to get the
#     latest HP distrobution of Apache.
#
#     uses &B_TODO($string)
################################################################################
sub UpgradeApache {
    &ActionLog("# sub UpgradeApache\n");

    if(&getGlobalConfig('Apache','updateapache') eq "Y"){
	my $upgrade_text = 
	    "Apache 1.3.19 and higher has chroot jail functionality build into the\n" .
	    "distribution.  In order to take advantage of this security feature\n" .
	    "download the latest copy from http://software.hp.com and then re-run\n" .
            "Bastille on your system.\n\n";
	&B_TODO($upgrade_text);
    }
}

1;







