/*
 * Copyright (c) 2000-2001 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/*
 * template - argus client template.
 *
 *  This module must define these routines:
 *
 *   (void) usage (void);
 *                    this routine should print the standard usage message
 *                    for the specific application.
 *
 *          ArgusClientInit ();
 *                    this is the application specific init
 *                    routine, which is called after all parsing
 *                    initialization is done, prior to reading the
 *                    first argus(1) datum.
 *
 *   (void) ArgusClientTimeout ();
 *                    this routine is called every second, when
 *                    the argus client is connected to a remote
 *                    data source using the -S flag.
 *
 *          RaProcessRecord ((struct ArgusRecord *) argus);
 *                    this routine is called from the other record
 *                    processing routines, to provide a common
 *                    argus processing function.
 *
 *          process_man ((struct ArgusRecord *) argus);
 *                    this routine should process managment control events;
 *
 *          process_tcp ((struct ArgusRecord *) argus);
 *                    this routine should process tcp events;
 *
 *          process_udp ((struct ArgusRecord *) argus);
 *                    this routine should process tcp events;
 *
 *          process_icmp ((struct ArgusRecord *) argus);
 *                    this routine should process tcp events;
 *
 *          process_ip ((struct ArgusRecord *) argus);
 *                    this routine should process tcp events;
 *
 *   (void) RaParseComplete (int);
 *                    this routine will be called after all the
 *                    monitor data has been read.
 *
 *
 *
 *  These modules can optionally extend the common routines functions:
 *
 *          parse_arg (argc, argv)
 *                    this routine can process client specific command
 *                    line options, specified with appOptstring.
 *
 *
 *
 *
 * written by Carter Bullard
 * QoSient, LLC
 *
 */



#ifndef ArgusClient
#define ArgusClient
#endif

#include <argus_client.h>


int RaInitialized = 0;

void
ArgusClientInit ()
{
   if (!(RaInitialized)) {
      RaInitialized++;
   }
}

int RaParseCompleting = 0;

void
RaParseComplete (int sig)
{
   if (!RaParseCompleting) {
      RaParseCompleting++;
   }
}

void
ArgusClientTimeout ()
{
}

void
parse_arg (int argc, char**argv)
{ 
}


void
usage ()
{
   extern char version[];
   fprintf (stderr, "Ratemplate Version %s\n", version);
   fprintf (stderr, "usage: %s \n", ArgusProgramName);
   fprintf (stderr, "usage: %s [options] -S remoteServer  [- filter-expression]\n", ArgusProgramName);
   fprintf (stderr, "usage: %s [options] -r argusDataFile [- filter-expression]\n\n", ArgusProgramName);

   fprintf (stderr, "options: -a             print record summaries on termination.\n");
   fprintf (stderr, "         -A             print application bytes.\n");
   fprintf (stderr, "         -b             dump packet-matching code.\n");
   fprintf (stderr, "         -c             print packet and byte counts.\n");
   fprintf (stderr, "         -C             treat the remote source as a Cisco Netflow source.\n");
   fprintf (stderr, "         -D <level>     specify debug level\n");
   fprintf (stderr, "         -E <file>      write records that are rejected by the filter into <file>\n");
   fprintf (stderr, "         -f <flowfile>  read flow model from <flowfile>.\n");
   fprintf (stderr, "         -F <conffile>  read configuration from <conffile>.\n");
   fprintf (stderr, "         -g             print record time duration.\n");
   fprintf (stderr, "         -G             print both start and last time values.\n");
   fprintf (stderr, "         -h             print help.\n");
   fprintf (stderr, "         -I             print transaction state and option indicators.\n");
   fprintf (stderr, "         -l             print last time values [default is start time].\n");
   fprintf (stderr, "         -m             print MAC addresses.\n");
   fprintf (stderr, "         -n             don't convert numbers to names.\n");
   fprintf (stderr, "         -p <digits>    print fractional time with <digits> precision.\n");
   fprintf (stderr, "         -P <portnum>   specify remote argus <portnum> (tcp/561).\n");
   fprintf (stderr, "         -q             quiet mode. don't print record outputs.\n");
   fprintf (stderr, "         -r <file>      read argus data <file>. '-' denotes stdin.\n");
   fprintf (stderr, "         -R             print out response data when availabile.\n");
   fprintf (stderr, "         -S <host>      specify remote argus <host>.\n");
   fprintf (stderr, "         -t <timerange> specify <timerange> for reading records.\n");
   fprintf (stderr, "               format:  timeSpecification[-timeSpecification]\n");
   fprintf (stderr, "                        timeSpecification: [mm/dd[/yy].]hh[:mm[:ss]]\n");
   fprintf (stderr, "                                            mm/dd[/yy]\n");
   fprintf (stderr, "         -T <secs>      attach to remote server for T seconds.\n");
   fprintf (stderr, "         -u             print time in Unix time format.\n");
#ifdef ARGUS_SASL
   fprintf (stderr, "         -U <user/auth> specify <user/auth> authentication information.\n");
#endif
   fprintf (stderr, "         -w <file>      write output to <file>. '-' denotes stdout.\n");
   fprintf (stderr, "         -z             print Argus TCP state changes.\n");
   fprintf (stderr, "         -Z <s|d|b>     print actual TCP flag values.<'s'rc | 'd'st | 'b'oth>\n");
   exit(1);
}


void
RaProcessRecord (struct ArgusRecord *argus)
{
}


void
process_man (struct ArgusRecord *argus)
{
   RaProcessRecord (argus);
}


void
process_tcp (struct ArgusRecord *argus)
{
   RaProcessRecord (argus);
}


void
process_icmp (struct ArgusRecord *argus)
{
   RaProcessRecord (argus);
}


void
process_udp (struct ArgusRecord *argus)
{
   RaProcessRecord (argus);
}


void
process_ip (struct ArgusRecord *argus)
{
   RaProcessRecord (argus);
}


void
process_arp (struct ArgusRecord *argus)
{
   RaProcessRecord (argus);
}


void
process_non_ip (struct ArgusRecord *argus)
{
   RaProcessRecord (argus);
}

