// ---------------------------------------------------------------------------
// - t_unicode.cpp                                                           -
// - standard object library - unicode class tester                          -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Unicode.hpp"

int main (int, char**) {
  using namespace afnix;

  // check stripl/stripr function
  static char SEP[] = {'\t', ' ', nilc};
  t_quad* scl = Unicode::stripl ("  A", SEP);
  t_quad* scr = Unicode::stripr ("a  ", SEP);
  if (scl[0] != Unicode::toquad ('A')) return 1;
  if (scr[0] != Unicode::toquad ('a')) return 1;
  delete [] scl;
  delete [] scr;

  // check tolower function
  t_quad* lcm = Unicode::tolower ("A");
  if (lcm[0] != Unicode::toquad ('a')) return 1;
  delete [] lcm;

  // check toupper function
  t_quad* ucm = Unicode::toupper ("a");
  if (ucm[0] != Unicode::toquad ('A')) return 1;
  delete [] ucm;

  // check for lower case value
  if (Unicode::islower (Unicode::toquad ('a')) == false) return 1;
  if (Unicode::islower (Unicode::toquad ('A')) == true)  return 1;

  // check for upper case value
  if (Unicode::isupper (Unicode::toquad ('Z')) == false) return 1;
  if (Unicode::isupper (Unicode::toquad ('z')) == true)  return 1;

  // check for letter
  if (Unicode::isletter (Unicode::toquad ('l')) == false) return 1;
  if (Unicode::isletter (Unicode::toquad ('0')) == true)  return 1;

  // check for digit
  if (Unicode::isdigit (Unicode::toquad ('0')) == false) return 1;
  if (Unicode::isdigit (Unicode::toquad ('l')) == true)  return 1;

  // check for terminal
  if (Unicode::isterm (Unicode::toquad ('l')) == false) return 1;
  if (Unicode::isterm (Unicode::toquad ('U')) == false) return 1;
  if (Unicode::isterm (Unicode::toquad ('0')) == false) return 1;
  if (Unicode::isterm (Unicode::toquad ('|')) == false) return 1;
  if (Unicode::isterm (Unicode::toquad (' ')) == false) return 1;

  // check length vs not combining length (U+00C0 = U+0041 + U+0300)
  t_quad* cs = Unicode::strmak ((char) 0xC0);
  if (Unicode::strlen (cs) != 1) return 1;
  if (Unicode::ncclen (cs) != 1) return 1;
  t_quad* ns = Unicode::strnrm (cs);
  if (Unicode::strlen (ns) != 2) return 1;
  if (Unicode::ncclen (ns) != 1) return 1;
  delete [] cs;
  delete [] ns;

  // done
  return 0;
}
