// ---------------------------------------------------------------------------
// - Crypto.cpp                                                              -
// - afnix cryptographic library - cryptographic function implementation     -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Aes.hpp"
#include "Md5.hpp"
#include "Sha1.hpp"
#include "Sha256.hpp"
#include "Sha384.hpp"
#include "Sha512.hpp"
#include "Crypto.hpp"

namespace afnix {
  
  // -------------------------------------------------------------------------
  // - hasher section                                                        -
  // -------------------------------------------------------------------------

  // create a new hasher by type

  Hasher* Crypto::mkhasher (const t_hasher type) {
    if (type == MD5)    return new Md5;
    if (type == SHA1)   return new Sha1;
    if (type == SHA256) return new Sha256;
    if (type == SHA384) return new Sha384;
    if (type == SHA512) return new Sha512;
    throw Exception ("hasher-error", "invalid hasher object type");
  }

  // create a new hasher by name

  Hasher* Crypto::mkhasher (const String& name) {
    if (name == "MD-5")    return new Md5;
    if (name == "SHA-1")   return new Sha1;
    if (name == "SHA-256") return new Sha256;
    if (name == "SHA-384") return new Sha384;
    if (name == "SHA-512") return new Sha512;
    throw Exception ("hasher-error", "invalid hasher object name", name);
  }

  // -------------------------------------------------------------------------
  // - cipher section                                                        -
  // -------------------------------------------------------------------------

  // create a new cipher by type and key

  Cipher* Crypto::mkcipher (const t_cipher type, const Key& key, 
			    const bool rflg) {
    if (type == AES)  return new Aes (key, rflg);
    throw Exception ("cipher-error", "invalid cipher object type");
  }

  // create a new cipher by name

  Cipher* Crypto::mkcipher (const String& name, const Key& key, 
			    const bool rflg) {
    if (name == "AES") return new Aes (key, rflg);
    throw Exception ("cipher-error", "invalid cipher object name", name);
  }
}
