/*
 * Copyright 2006 Ricoh Corporation.
 * 
 * 
 * APACHE LICENSE VERSION 2.0
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 
 * RICOH DEVELOPER PROGRAM SUPPORT:
 * 
 * Support for this software is available only to "Premier Plus" members
 * of the Ricoh Developer Program (RiDP).  You may find out more 
 * information about the Program at
 * 
 *      http://americas.ricoh-developer.com
 * 
 * Premier plus members may find answers and ask questions through the
 * RiDP customer help website at
 * 
 *      https://ridp.custhelp.com
 * 
 * Developers who are not RiDP members may still use this software as
 * stipulated in the license terms given above.
 *
 */

// import ESA (Embedded Software Architecture)
import jp.co.ricoh.dsdk.panel.*;
import jp.co.ricoh.dsdk.panel.event.*;

public class Puzzle15AboutDialog extends Dialog implements ActionListener
{
	Puzzle15AboutDialog(Frame parent)
	{
		super(parent, true);
		
		// position the about box
		int parentWidth = parent.getWidth();
		int parentHeight = parent.getHeight(); 

		setLocation(25, 25);
		setSize(parentWidth - 50, parentHeight - 50);

		// create label with product info
		String[] lines =
		{
		    "15-Tile Slide Puzzle",
		    "Implemented in Java using the Embedded Software Architecture",
		    "",
		    "Scramble tiles and put them back in order. Tap any tile next to the empty space to",
			"move it.",
		    "",
		    "The solution algorithm is based on a Java applet at http://www.javaonthebrain.com.",
	/*
		    "",
		    "In 1878 Sam Loyd, America's greatest puzzle-expert, \"drove the whole world crazy\"",
		    "with this 14-15 puzzle. It was a variation on the \"Puzzle of 15\" which was made",
		    "and sold by the Embossing Company from New York about 10 years earlier.",
*/
		};
		
		int top = 30;
		int left = 20;
		
		for (int line=0; line < lines.length; ++line)
		{
			Label label = new Label(lines[line]);
			
			int labelHeight = 0;

			if (line == 0)
			{
				labelHeight = 16;
				label.setFont(Font.F16);
			}
			else
			{
				labelHeight = 12;
				label.setFont(Font.F12);
			}
			
			label.setLocation(left, top);
			label.setSize(parentWidth - 50 - (left * 2), labelHeight);
			
			add(label);

			top += labelHeight;
		}
/*
        // would have used this code but LabelArea seems hopelessly
        // 	broken; it only seems to show one line over and over;
        //  Label itself seems only able to show one line		
		LabelArea aboutMsg = new LabelArea(lines);
		
		aboutMsg.setLocation(10, 10);
		aboutMsg.setSize(parentWidth - 70, parentHeight - 100);
		
		aboutMsg.setFont(Font.F12);
		aboutMsg.setDisplayedLines(lines.length);
		
		add(aboutMsg);
*/
		// create OK button
		Button okButton = new Button();
		
		okButton.setLocation((parentWidth/2) - 25 - 40, parentHeight - 90);
		okButton.setSize(80, 30);
		okButton.setShape(Button.Shape.NOCNR2);
		okButton.setLabel("OK");
		
		okButton.addActionListener(this);

		add(okButton);

		return;
	}

    public void actionPerformed(ActionEvent evt)
    {
		dispose();
		
		return;
    }
}
