package expectj;

/**
 * This Class is the starting point of the ExpectJ Utility. This class
 * acts as factory for all the Spawned Processes.
 *
 * @author	Sachin Shekar Shetty  
 * @version 1.0
 */
public class ExpectJ {

    // Debugger Variable
    private Debugger debug = null;

    // Default timeout, -1 indicating wait for indefinite time 
    private long m_lDefaultTimeOut = -1;

    /**
     * Private constructor 
     *
     * @param sLogFile Location of the log file
     * @param lDefaultTimeOut default time out for the expect commands
     * on the spawned process.  -1 default time out indicates indefinite
     * timeout
     *
     */
    private void initialize(String sLogFile, long lDefaultTimeOut) {

        if (sLogFile != null) {
            debug = new Debugger(sLogFile, "JExpect");            
        }
           
        m_lDefaultTimeOut = lDefaultTimeOut;

        
    }
   
    /**
     * Constructor
     *
     * @param sLogFile Location of the log file
     * @param lDefaultTimeOut default time out for the expect commands
     * on the spawned process.  -1 default time out indicates indefinite
     * timeout
     */
    public ExpectJ(String sLogFile, long lDefaultTimeOut) {
        
        initialize(sLogFile, lDefaultTimeOut);                

    }

    /**
     * This method spawns a process and returns a object representing
     * the SpawnedProcess. Further expect commands can be invoked on the
     * SpawnedProcess Object. 
     *
     * @param sCommand command to be executed
     */

    public ExpectHandler spawn(String sCommand) throws ExpectJException    {

        return new SpawnedProcess(sCommand, m_lDefaultTimeOut);

    } 

    /**
     * This method opens a socket connection to a specified address
     * and port number, and returns an object that will read and write
     * to that connection.  Further expect commands can be invoked on the
     * object returned. 
     *
     * @param serverAddress server to connect to
     * @param port port number to use
     */

    public ExpectHandler openSocket(String serverAddress, int port) throws ExpectJException    {

        return new SocketHandler(serverAddress, port, m_lDefaultTimeOut);

    } 
    
    public ExpectHandler openSocket(String serverAddress) throws ExpectJException    {
    	
    	return this.openSocket(serverAddress, 23);
    }

    

}
