/*
 * Copyright 2006 Ricoh Corporation.
 * 
 * 
 * APACHE LICENSE VERSION 2.0
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 
 * RICOH DEVELOPER PROGRAM SUPPORT:
 * 
 * Support for this software is available only to "Premier Plus" members
 * of the Ricoh Developer Program (RiDP).  You may find out more 
 * information about the Program at
 * 
 *      http://americas.ricoh-developer.com
 * 
 * Premier plus members may find answers and ask questions through the
 * RiDP customer help website at
 * 
 *      https://ridp.custhelp.com
 * 
 * Developers who are not RiDP members may still use this software as
 * stipulated in the license terms given above.
 *
 */ 

import java.util.ArrayList;
import java.util.StringTokenizer;

import expectj.ExpectJ;
import expectj.ExpectJException;
import expectj.ExpectHandler;
import jp.co.ricoh.dsdk.core.manager.XletManager;

import jp.co.ricoh.dsdk.panel.Button;
import jp.co.ricoh.dsdk.panel.Container;
import jp.co.ricoh.dsdk.panel.Dialog;
import jp.co.ricoh.dsdk.panel.Frame;
import jp.co.ricoh.dsdk.panel.HorizontalAlignment;
import jp.co.ricoh.dsdk.panel.Label;
import jp.co.ricoh.dsdk.panel.Language;
import jp.co.ricoh.dsdk.panel.SoftKeyboard;
import jp.co.ricoh.dsdk.panel.SoftKeyboardOpenException;
import jp.co.ricoh.dsdk.panel.Text;
import jp.co.ricoh.dsdk.panel.Window;
import jp.co.ricoh.dsdk.panel.event.ActionEvent;
import jp.co.ricoh.dsdk.panel.event.ActionListener;
import jp.co.ricoh.dsdk.panel.event.KeyEvent;
import jp.co.ricoh.dsdk.panel.event.KeyListener;
import jp.co.ricoh.dsdk.xlet.UnavailableContainerException;
import jp.co.ricoh.dsdk.xlet.Xlet;
import jp.co.ricoh.dsdk.xlet.XletContext;
import jp.co.ricoh.dsdk.xlet.XletStateChangeException;

/**
 * this xlet creates a telnet connection to localhost, (127.0.0.1),
 * and uses this connection to configure SNTP settings aboard the MFP
 * NOTE: the expectj package must be compressed into TimeSet.jar The
 * MFP throws a java.security.AcessControlException if you attempt to 
 * utilize the expectj classes from an additional jar. Also, be aware 
 * that after altering the SNTP settings, the telnet logout initiated
 * by the successful operation of this xlet will cause an automatic
 * reboot of the MFP
 */
public class TimeSet implements Xlet {

	private XletContext context;	
	String address = "";
	String sntpServer = "unknown";
	String interval = "unknown";
	String timeZone = "unknown";

	String userName = "admin";
	String password = "";
	
	final String parameterError = "Invalid parameter"; 
	
	private Button set;
	private Button serverBtn;
	private Button intervalBtn;
	private Button timeZoneBtn;
	private Button revert;
	
	private Label serverArea;
	private Label intervalArea;
	private Label timeZoneArea;
	private Label splashArea;
	private Frame rootContainer;
	private Dialog alert;
	ExpectJ tnInterface;
	static ExpectHandler  sp = null;
	
	public void initXlet(XletContext arg0) throws XletStateChangeException {
		System.out.println("executing TimeSet.initXlet()");
		//load the context
		context = arg0;
		
		try 
	  	{
			Container parent = context.getContainer();
			while(!(parent instanceof Frame))
			{
				parent = parent.getParent();
				if(parent == null)
					break;
			}
			if(parent == null)
			{
				System.exit(0);
			}
			rootContainer = (Frame)parent;
	  	}catch (UnavailableContainerException ex) {
			throw new XletStateChangeException();
		}
                
                if (address == null || address.trim().length() == 0 )
                {
                    openAlert("No SNTP server is defined.",true);
                    return;
//                    destroyXlet(true);
                }
	  	
	  	try {
	  		System.out.println("calling TimeSet.startSession()");
			startSession();
			System.out.println("calling TimeSet.retrieveCurrentSNTP()");
			retrieveCurrentSNTP();
		} catch (ExpectJException e) {
			e.printStackTrace();
	  		System.exit(0);
		}
		
		buildGUI();
	}

	private void retrieveCurrentSNTP() throws ExpectJException 
	{
		System.out.println("TimeSet.retrieveCurrentSNTP() sending sntp command");
		sp.send("sntp\n");
		System.out.println("TimeSet.retrieveCurrentSNTP() sntp command sent, waiting for reply");
		String sntpResult = sp.capture("msh>");
		
		System.out.print(sntpResult);
		
		ArrayList targets = new ArrayList();
		StringTokenizer tokens = new StringTokenizer(sntpResult);
		while(tokens.hasMoreTokens()){
			targets.add(tokens.nextToken());
		}
		
		sntpServer = (String) targets.get(2);
		interval = (String) targets.get(4);
		timeZone = (String) targets.get(6);
	}


	private void startSession() throws ExpectJException 
	{
		System.out.println("TimeSet.startSession()");
		tnInterface = new ExpectJ(null, -1);
		System.out.println("TimeSet.startSession() new tnInterface constructed");
		sp = tnInterface.openSocket(address);
		System.out.println("TimeSet.startSession() socket open");
		System.out.println("TimeSet.startSession() waiting for login prompt");
		sp.expect("login:");
		System.out.println("TimeSet.startSession() got the prompt, sending username");
		sp.send(userName+"\n");
		System.out.println("TimeSet.startSession()username sent");
		if (sp.isLastExpectTimeOut()) {
			System.err.println("Did not match");
			System.exit(1);
		}
		System.out.println("TimeSet.startSession()waiting for password prompt");
		sp.expect("Password:");
		sp.send(password+"\n");
		sp.expect("msh>");
	}


	private void buildGUI() 
	{
		splashArea = new Label("TimeSet Xlet: set MFP SNTP settings");
		splashArea.setBounds(180, 25, 200, 25);
		rootContainer.add(splashArea);
		
		////////////////////////////////////////////////////////////////
//		create labels
		////////////////////////////////////////////////////////////////
		serverArea = new Label(sntpServer);
		serverArea.setBounds(140, 70, 220, 25);
		
		intervalArea = new Label(interval);
		intervalArea.setBounds(140, 105, 200, 25);
		
		timeZoneArea = new Label(timeZone);
		timeZoneArea.setBounds(140, 140, 200, 25);
		
		rootContainer.add(serverArea);
		rootContainer.add(intervalArea);
		rootContainer.add(timeZoneArea);
		
		///////////////////////////////////////////////////////////////
		//create buttons
		///////////////////////////////////////////////////////////////
		revert = new Button("revert");
		revert.setBounds(340, 191, 100, 25);
		revert.addActionListener(
			new ActionListener()
			{
				public void actionPerformed(ActionEvent arg0) 
				{
					try {
						retrieveCurrentSNTP();
					} catch (ExpectJException e) {
						e.printStackTrace();
					}
					serverArea.setText(sntpServer);
					intervalArea.setText(interval);
					timeZoneArea.setText(timeZone);
					rootContainer.repaint();
				}
			}
		);
		
		set = new Button("set time");
		set.setBounds(445, 191, 100, 25);
		set.addActionListener(
				new ActionListener()
				{
					public void actionPerformed(ActionEvent arg0) 
					{
						sntpServer = serverArea.getText();
						interval = intervalArea.getText();
						timeZone = timeZoneArea.getText();
						
						
							try
							{
								sp.send("sntp server " + sntpServer +"\n");
								String error = sp.capture("msh>");
								if( error.indexOf(parameterError) >= 0)
								{
									openAlert("Bad Server",false)	;
									return;
								}
								
								sp.send("sntp interval "+interval+"\n");
								error = sp.capture("msh>");
								if( error.indexOf(parameterError)>= 0)
								{
									openAlert("Bad Interval",false)	;
									return;
								}
								
								sp.send("sntp timezone "+timeZone+"\n");
								error = sp.capture("msh>");
								if( error.indexOf(parameterError) >= 0)
								{
									openAlert("Bad Timezone",false)	;
											return;
								}
                                
								logout();
								destroyXlet(false);
								context = null;
								
							}catch(ExpectJException e)
							{
								e.printStackTrace();
							} catch (XletStateChangeException e) {
								e.printStackTrace();
							}
						
					}
					
				}
		);
		
		//create buttons
		serverBtn = new Button("SNTP Server");
		serverBtn.setBounds(50, 70, 85, 25);
		serverBtn.addActionListener(
				new ActionListener()
				{
					public void actionPerformed(ActionEvent arg0) {
						
						//System.out.println("server button pressed");
						
						// create soft keyboard
						SoftKeyboard skb = new SoftKeyboard((Window)rootContainer, new Text("Set Server"));
						skb.setLanguage(Language.en);
						skb.addKeyListener(
								new KeyListener()
								{
									public void keyPressed(KeyEvent e)
									{
										if (e.getKeyCode() == KeyEvent.KEY_SOFT_OK
												|| e.getKeyCode() == KeyEvent.KEY_SOFT_CANCEL) {
										SoftKeyboard obj = (SoftKeyboard) e.getSource();
							
										String output = obj.getStrdata();
										
										if (output != null) {
											serverArea.setText(new Text(output));
											serverArea.repaint();
										}
										
										}
									}

									public void keyTyped(KeyEvent arg0) {}

									public void keyReleased(KeyEvent arg0) {}
								}
						);
						try {
							skb.show();
						} catch (SoftKeyboardOpenException e1) {
							e1.printStackTrace();
						}
					}					
				}
		);
		
		intervalBtn = new Button("Interval");
		intervalBtn.setBounds(50, 105, 85, 25);
		intervalBtn.addActionListener(
				new ActionListener()
				{
					public void actionPerformed(ActionEvent arg0) {
						
						//System.out.println("server button pressed");
						
						// create soft keyboard
						SoftKeyboard skb = new SoftKeyboard((Window)rootContainer, new Text("Set interval"));
						skb.setLanguage(Language.en);
						skb.addKeyListener(
								new KeyListener()
								{
									public void keyPressed(KeyEvent e)
									{
										if (e.getKeyCode() == KeyEvent.KEY_SOFT_OK
												|| e.getKeyCode() == KeyEvent.KEY_SOFT_CANCEL) {
										SoftKeyboard obj = (SoftKeyboard) e.getSource();
							
										String output = obj.getStrdata();
										
										if (output != null) {
											intervalArea.setText(new Text(output));
											intervalArea.repaint();
										}
										
										}
									}

									public void keyTyped(KeyEvent arg0) {}

									public void keyReleased(KeyEvent arg0) {}
								}
						);
						try {
							skb.show();
						} catch (SoftKeyboardOpenException e1) {
							e1.printStackTrace();
						}
					}					
				}
		);
		
		timeZoneBtn = new Button("Time Zone");
		timeZoneBtn.setBounds(50, 140, 85, 25);
		timeZoneBtn.addActionListener(
				new ActionListener()
				{
					public void actionPerformed(ActionEvent arg0) {
						
						// create soft keyboard
						SoftKeyboard skb = new SoftKeyboard((Window)rootContainer, new Text("Set timezone"));
						skb.setLanguage(Language.en);
						skb.addKeyListener(
								new KeyListener()
								{
									public void keyPressed(KeyEvent e)
									{
										if (e.getKeyCode() == KeyEvent.KEY_SOFT_OK
												|| e.getKeyCode() == KeyEvent.KEY_SOFT_CANCEL) {
										SoftKeyboard obj = (SoftKeyboard) e.getSource();
							
										String output = obj.getStrdata();
										
										if (output != null) {
											timeZoneArea.setText(new Text(output));
											timeZoneArea.repaint();
										}
										
										}
									}

									public void keyTyped(KeyEvent arg0) {}

									public void keyReleased(KeyEvent arg0) {}
								}
						);
						try {
							skb.show();
						} catch (SoftKeyboardOpenException e1) {
							e1.printStackTrace();
						}
					}					
				}
		);
		
		//add the new buttons to the main window
		rootContainer.add(timeZoneBtn);
		rootContainer.add(intervalBtn);
		rootContainer.add(serverBtn);
		rootContainer.add(set);
		rootContainer.add(revert);
	}


	public void startXlet() throws XletStateChangeException {
		// TODO Auto-generated method stub

	}

	public void pauseXlet() {
		// TODO Auto-generated method stub-

	}

	public void destroyXlet(boolean arg0) throws XletStateChangeException {
            if(sp != null)
                if (!sp.isClosed())
		{
			try {
				sp.send("logout\n");
				sp.stop();
				sp = null;
			} catch (ExpectJException e) {
				e.printStackTrace();
			}
		}
            tnInterface = null;
            rootContainer.dispose();
	}

	private void openAlert(String message,final boolean exit) 
	{
		alert = new Dialog(rootContainer, true);
		alert.setAppearance(Window.Appearance.ERROR);
		
		alert.setBounds(200, 25, 200, 200);
		
		Label alertMsg1 = new Label(parameterError);
		alertMsg1.setBounds(25, 30, 150, 25);
		alertMsg1.setHorizontalAlignment(HorizontalAlignment.CENTER);
		
		Label alertMsg2 = new Label(message);
		alertMsg2.setBounds(25, 60, 150, 25);
		alertMsg2.setHorizontalAlignment(HorizontalAlignment.CENTER);
		
		Label alertMsg3 = new Label("re-enter value.");
		alertMsg3.setBounds(25, 90, 150, 25);
		alertMsg3.setHorizontalAlignment(HorizontalAlignment.CENTER);
		
		alert.add(alertMsg1);
		alert.add(alertMsg2);
		alert.add(alertMsg3);
		
		Button exitAlert = new Button("close");
		exitAlert.setBounds(50, 150, 100, 25);
		exitAlert.addActionListener(
			new ActionListener(){
				public void actionPerformed(ActionEvent arg0){
					alert.dispose();
                                        if (exit)
                                        {
                                            System.exit(1);
                                        }
				}
			}
		
		);
		alert.add(exitAlert);
		
		alert.show();
	}
	
	private void logout()
	{
		try{
	//		 close telnet session
			sp.send("logout\n");
			System.out.println(sp.capture("Logout Maintenance Shell."));
			System.out.println(sp.capture(""));
			System.out.println(sp.capture("Do you save configuration data? (yes/no/return) >"));
			sp.send("yes\n");
			System.out.println(sp.capture("Now, Save data."));
			sp.stop();
		}catch(ExpectJException e){
			e.printStackTrace();
		}
	}

}
