/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.processmanager.manager.ejb;

import javax.ejb.*;
import java.util.*;

import com.sun.j2ee.blueprints.servicelocator.ejb.*;

public abstract class ManagerBean implements EntityBean {
    
    private EntityContext context = null;
    
    // CMP fields
    public abstract String getOrderId();
    public abstract void setOrderId(String orderId);
    
    public abstract String getStatus();
    public abstract void setStatus(String status);

    public abstract String getActivityOrderStatus();
    public abstract void setActivityOrderStatus(String status);

    public abstract String getAirlineOrderStatus();
    public abstract void setAirlineOrderStatus(String status);

    public abstract String getLodgingOrderStatus();
    public abstract void setLodgingOrderStatus(String status);

    public abstract boolean getOrderError();
    public abstract void setOrderError(boolean orderError);
  
    // EJB create methods
    public String ejbCreate(String orderId, String status, 
          String actyOrderStatus,
          String airlineOrderStatus, String lodgOrderStatus,
          boolean orderError) throws CreateException {
        setOrderId(orderId);
        setStatus(status);
        setActivityOrderStatus(actyOrderStatus);
        setAirlineOrderStatus(airlineOrderStatus);
        setLodgingOrderStatus(lodgOrderStatus);
        setOrderError(orderError);
        return null;
    }
    
    public void ejbPostCreate(String orderId, String status, String actyOrderStatus,
            String airlineOrderStatus, String lodgOrderStatus,boolean orderError) throws CreateException {}
          
    public void setEntityContext(EntityContext c) {
        context = c;
    }
    public void unsetEntityContext() {
        context = null;
    }
    public void ejbRemove() throws RemoveException {
    }
    public void ejbActivate() {
    }
    public void ejbPassivate() {
    }
    public void ejbStore() {
    }
    public void ejbLoad() {
    }
}
