<%-- 
/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/
 --%>
<%@ taglib prefix="sql" uri="http://java.sun.com/jsp/jstl/sql" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@page contentType="text/html"%>

<fmt:setLocale value="en_US" />

<sql:setDataSource dataSource="jdbc/CatalogDB"/>

<sql:query var="lodgings"> 
select lodgingid,name, description, price, imageuri from lodging where location = ? and locale = ?
 <sql:param>${cart.destination}</sql:param>
 <sql:param>en_US</sql:param>
</sql:query>
<table>
<c:forEach var="lodging" varStatus="lodgingStatus" items="${lodgings.rows}">
<form action="cart.do" method="POST">
 <input type="HIDDEN" name ="target_action" value="purchase_lodging"/>
 <input type="HIDDEN" name ="tab" value="${param.tab}"/>
  <tr>
   <td>
     <c:url var="imageURL" value="images/${lodging.imageuri}"/>
     <image src="${imageURL}" alt="${lodging.name} Image">
   </td>
   <td>
    <h2>${lodging.name}</h2><br><br>
     ${lodging.description}
    </td>
   <td><b>Price:</b> <fmt:formatNumber value="${lodging.price}" type="currency" /> per room per night</td>
    <td>
     <input type="HIDDEN" name="lodging_id" value="${lodging.lodgingid}">
     <input type="SUBMIT"  value="Purchase"  name="Purchase">
    </td>
  </form>
  </tr>
  <c:choose>
     <c:when test="${lodgingStatus.last == false}">
      <tr><td colspan="5"><hr width="90%"></td></tr>
     </c:when>
    </c:choose>
 </c:forEach>
  <tr><td colspan="4">&nbsp;</td></tr>
  <tr>
   <td colspan="4" align="right">
   <form action="cart.do" method="POST">
     <input type="SUBMIT" value="Cancel" name="Cancel">
   </form>
   </td>
  </tr>
</table>