/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xml.tools.generator;

import java.awt.*;
import javax.swing.*;
import java.net.URL;
import java.net.MalformedURLException;

import org.netbeans.modules.xml.core.lib.A11YUtil;

/**
 * A panel allowing to customize SAX generator i.e. setting file locations and element mapping.
 * <p>
 * The UI performs name checks and colors appropriate input fields giving a user feedback.
 *
 * @author  Petr Kuzel
 * @version 1.0
 */
public final class SAXGeneratorFilePanel extends SAXGeneratorAbstractPanel implements java.awt.event.ActionListener {

    /** Serial Version UID */
    private static final long serialVersionUID =-8950908568784619306L;  
        
    private static final Util.NameCheck check = Util.JAVA_CHECK;
   
    private java.util.ResourceBundle bundle = org.openide.util.NbBundle.getBundle(SAXGeneratorFilePanel.class);

    /** Creates new form SAXGeneratorCustomizer */
    public SAXGeneratorFilePanel() {
//        try {
//            this.putClientProperty("WizardPanel_helpURL", new URL("nbresloc:/org/netbeans/modules/xml/tools/generator/SAXGeneratorFilePanel.html"));  //NOI18N
//        } catch (MalformedURLException ex) {
//        }
    }
    
    private final ValidatingTextField.Validator NAME_VALIDATOR = new ValidatingTextField.Validator() {
        public boolean isValid(String value) {
            boolean ret = check.checkName(value);
            if (ret) {
                setValid(checkNames());
            } else {
                setValid(false);
            }
            
            return ret;
        }
        
        public String getReason() {
            return Util.THIS.getString("MSG_file_err_1");
        }
    };
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        descTextArea = new javax.swing.JTextArea();
        interfaceLabel = new javax.swing.JLabel();
        interfaceTextField = new org.netbeans.modules.xml.tools.generator.ValidatingTextField();
        handlerImplLabel = new javax.swing.JLabel();
        handlerImplTextField = new org.netbeans.modules.xml.tools.generator.ValidatingTextField();
        stubLabel = new javax.swing.JLabel();
        stubTextField = new org.netbeans.modules.xml.tools.generator.ValidatingTextField();
        parsletLabel = new javax.swing.JLabel();
        parsletTextField = new org.netbeans.modules.xml.tools.generator.ValidatingTextField();
        parsletImplLabel = new javax.swing.JLabel();
        parsletImplTextField = new org.netbeans.modules.xml.tools.generator.ValidatingTextField();
        saveCheckBox = new javax.swing.JCheckBox();
        saveLabel = new javax.swing.JLabel();
        saveTextField = new org.netbeans.modules.xml.tools.generator.ValidatingTextField();
        fillPanel = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        setName(Util.THIS.getString ("SAXGeneratorFilePanel.Form.name"));
        setPreferredSize(new java.awt.Dimension(480, 350));
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentHidden(java.awt.event.ComponentEvent evt) {
                formComponentHidden(evt);
            }
        });
        addContainerListener(new java.awt.event.ContainerAdapter() {
            public void componentRemoved(java.awt.event.ContainerEvent evt) {
                formComponentRemoved(evt);
            }
        });

        descTextArea.setWrapStyleWord(true);
        descTextArea.setLineWrap(true);
        descTextArea.setEditable(false);
        descTextArea.setForeground(new java.awt.Color(102, 102, 153));
        descTextArea.setFont(javax.swing.UIManager.getFont ("Label.font"));
        descTextArea.setText(java.util.ResourceBundle.getBundle("org/netbeans/modules/xml/tools/generator/Bundle").getString("DESC_saxw_files"));
        descTextArea.setDisabledTextColor(javax.swing.UIManager.getColor ("Label.foreground"));
        descTextArea.setEnabled(false);
        descTextArea.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        add(descTextArea, gridBagConstraints);

        interfaceLabel.setLabelFor(interfaceTextField);
        org.openide.awt.Mnemonics.setLocalizedText(interfaceLabel, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "SAXGeneratorCustomizer.interfaceLabel.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(interfaceLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(interfaceTextField, gridBagConstraints);

        handlerImplLabel.setLabelFor(handlerImplTextField);
        org.openide.awt.Mnemonics.setLocalizedText(handlerImplLabel, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "SAXGeneratorFilePanel.handlerImplLabel.text", new Object[] {}));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(handlerImplLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(handlerImplTextField, gridBagConstraints);

        stubLabel.setLabelFor(stubTextField);
        org.openide.awt.Mnemonics.setLocalizedText(stubLabel, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "SAXGeneratorCustomizer.stubLabel.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(stubLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(stubTextField, gridBagConstraints);

        parsletLabel.setLabelFor(parsletTextField);
        org.openide.awt.Mnemonics.setLocalizedText(parsletLabel, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "SAXGeneratorCustomizer.parsletLabel.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(parsletLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(parsletTextField, gridBagConstraints);

        parsletImplLabel.setLabelFor(parsletImplTextField);
        org.openide.awt.Mnemonics.setLocalizedText(parsletImplLabel, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "SAXGeneratorFilePanel.parsletImplLabel.text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(parsletImplLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(parsletImplTextField, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(saveCheckBox, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "PROP_save_it"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(saveCheckBox, gridBagConstraints);

        saveLabel.setLabelFor(saveTextField);
        org.openide.awt.Mnemonics.setLocalizedText(saveLabel, org.openide.util.NbBundle.getMessage(SAXGeneratorFilePanel.class, "PROP_bindings_label"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(saveLabel, gridBagConstraints);

        saveTextField.setEditable(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 0, 0);
        add(saveTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        add(fillPanel, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents
        
    private void formComponentHidden(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentHidden
        updateModel();  //??? does not occur
    }//GEN-LAST:event_formComponentHidden
  
    private void formComponentRemoved(java.awt.event.ContainerEvent evt) {//GEN-FIRST:event_formComponentRemoved
        updateModel();  //??? does not occur
    }//GEN-LAST:event_formComponentRemoved
  
    protected void updateModel() {
        model.setHandler(interfaceTextField.getText());
        model.setParslet(parsletTextField.getText());
        model.setStub(stubTextField.getText());
        model.setParsletImpl(parsletImplTextField.getText());
        model.setHandlerImpl(handlerImplTextField.getText());
        model.setBindnings(saveCheckBox.isSelected() ? saveTextField.getText() : null);
    }
  
  
    protected void initView() {
        initComponents();
                    
        interfaceTextField.setText(model.getHandler());
        stubTextField.setText(model.getStub());
        handlerImplTextField.setText(model.getHandlerImpl());        
        parsletTextField.setText(model.getParslet());
        parsletImplTextField.setText(model.getParsletImpl());
        saveTextField.setText(model.getBindings());

        interfaceTextField.setValidator(NAME_VALIDATOR);
        stubTextField.setValidator(NAME_VALIDATOR);
        handlerImplTextField.setValidator(NAME_VALIDATOR);
        parsletTextField.setValidator(NAME_VALIDATOR);
        parsletImplTextField.setValidator(NAME_VALIDATOR);
        
        saveCheckBox.setSelected(model.getBindings() != null);
        
        initAccessibility();
    }
  
    protected void updateView() {
        
        parsletTextField.setVisible(hasParslets());
        parsletLabel.setVisible(hasParslets());
        parsletImplTextField.setVisible(hasParslets());
        parsletImplLabel.setVisible(hasParslets());
        
        doLayout();
        setValid(checkNames());
        
    }
  
    /** Get notified by DialigDescriptor */
    public void actionPerformed(java.awt.event.ActionEvent p1) {
        updateModel();
    }
  
    //
    // Check all entered names
    //
    private boolean checkNames() {

        return  check.checkName(interfaceTextField.getText()) 
                && (not(hasParslets()) || check.checkName(parsletTextField.getText()))
                && check.checkName(stubTextField.getText())
                && (not(hasParslets()) || check.checkName(parsletImplTextField.getText()))
                && check.checkName(handlerImplTextField.getText());
        
    }

    private boolean hasParslets() {
        return (model.getParsletBindings().isEmpty() == false);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextArea descTextArea;
    private javax.swing.JPanel fillPanel;
    private javax.swing.JLabel handlerImplLabel;
    private org.netbeans.modules.xml.tools.generator.ValidatingTextField handlerImplTextField;
    private javax.swing.JLabel interfaceLabel;
    private org.netbeans.modules.xml.tools.generator.ValidatingTextField interfaceTextField;
    private javax.swing.JLabel parsletImplLabel;
    private org.netbeans.modules.xml.tools.generator.ValidatingTextField parsletImplTextField;
    private javax.swing.JLabel parsletLabel;
    private org.netbeans.modules.xml.tools.generator.ValidatingTextField parsletTextField;
    private javax.swing.JCheckBox saveCheckBox;
    private javax.swing.JLabel saveLabel;
    private org.netbeans.modules.xml.tools.generator.ValidatingTextField saveTextField;
    private javax.swing.JLabel stubLabel;
    private org.netbeans.modules.xml.tools.generator.ValidatingTextField stubTextField;
    // End of variables declaration//GEN-END:variables

    /** Initialize accesibility
     */
    public void initAccessibility(){

        interfaceTextField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_interfaceTextField"));        
        handlerImplTextField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_handlerImplTextField"));
        stubTextField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_stubTextField"));
        parsletTextField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_parsletTextField"));
        parsletImplTextField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_parsletImplTextField"));
        
        saveTextField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_saveTextField"));
        saveTextField.addFocusListener(A11YUtil.getA11YJTextFieldSupport());
        
        saveCheckBox.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_saveCheckBox"));
        saveCheckBox.getAccessibleContext().setAccessibleName(Util.THIS.getString("ACSN_saveCheckBox"));   
        
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_SAXGeneratorFilePanel"));
    }    
}
