/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * NamespacePanel.java
 *
 * Created on December 20, 2005, 5:49 PM
 */

package org.netbeans.modules.xml.schema.abe.nodes.properties;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 *
 * @author  Todd Fast, todd.fast@sun.com
 */
public class NamespacePanel extends javax.swing.JPanel
        implements ActionListener, ListSelectionListener, DocumentListener {

    static final long serialVersionUID = 1L;
    public static final String PROP_VALID_SELECTION="validSelection";
    private boolean isValid=true;
    /** Creates new form NotationSystemForm */
    public NamespacePanel(String currentTns, Collection<String> uris, Collection<NamespaceEditor.Option> options) {
        initComponents();
        initialize(currentTns,uris,options);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        noNamespaceRadioButton = new javax.swing.JRadioButton();
        schemaNamespaceRadioButton = new javax.swing.JRadioButton();
        otherNamespaceRadioButton = new javax.swing.JRadioButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        uriList = new javax.swing.JList();
        otherNamespaceTextField = new javax.swing.JTextField();

        noNamespaceRadioButton.setText(org.openide.util.NbBundle.getBundle(NamespacePanel.class).getString("LBL_NoNamespace")); // NOI18N
        noNamespaceRadioButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        noNamespaceRadioButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        buttonGroup1.add(noNamespaceRadioButton);
        noNamespaceRadioButton.addActionListener(this);

        schemaNamespaceRadioButton.setText(org.openide.util.NbBundle.getBundle(NamespacePanel.class).getString("LBL_SchemaNamespace")); // NOI18N
        schemaNamespaceRadioButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        schemaNamespaceRadioButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        buttonGroup1.add(schemaNamespaceRadioButton);
        schemaNamespaceRadioButton.addActionListener(this);

        otherNamespaceRadioButton.setText(org.openide.util.NbBundle.getBundle(NamespacePanel.class).getString("LBL_OtherNamespace")); // NOI18N
        otherNamespaceRadioButton.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        otherNamespaceRadioButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        buttonGroup1.add(otherNamespaceRadioButton);
        otherNamespaceRadioButton.addActionListener(this);

        uriList.setMinimumSize(null);
        uriList.setPreferredSize(null);
        uriList.setVisibleRowCount(4);
        uriList.addListSelectionListener(this);
        jScrollPane1.setViewportView(uriList);

        otherNamespaceTextField.setMinimumSize(null);
        otherNamespaceTextField.setPreferredSize(null);
        otherNamespaceTextField.getDocument().addDocumentListener(this);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(17, 17, 17)
                        .add(otherNamespaceTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 374, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(17, 17, 17)
                        .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 374, Short.MAX_VALUE))
                    .add(schemaNamespaceRadioButton)
                    .add(otherNamespaceRadioButton)
                    .add(noNamespaceRadioButton))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(noNamespaceRadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(schemaNamespaceRadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 134, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(otherNamespaceRadioButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(otherNamespaceTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents


    private void initialize(String currentTns, final Collection<String> uris, Collection<NamespaceEditor.Option> options) {
        // hide radio button for uri list and uri list
        if (uris==null || uris.isEmpty()) {
            schemaNamespaceRadioButton.setVisible(false);
            uriList.setVisible(false);
        } else {
            uriList.setListData(uris.toArray(new String[uris.size()]));
        }
        // hide other radio buttons if needed
        if(!options.contains(NamespaceEditor.Option.None)) {
            noNamespaceRadioButton.setSelected(false);
            noNamespaceRadioButton.setVisible(false);
        }
        if(currentTns==null || currentTns.trim().length()==0) {
            uriList.setEnabled(false);
            if(noNamespaceRadioButton.isVisible()) {
                noNamespaceRadioButton.setSelected(true);
                otherNamespaceTextField.setEnabled(false);
            } else if (otherNamespaceRadioButton.isVisible()) {
                otherNamespaceRadioButton.setSelected(true);
                otherNamespaceTextField.setEnabled(true);
            }
        } else if(uris!=null && uris.contains(currentTns)) {
            schemaNamespaceRadioButton.setSelected(true);
            uriList.setSelectedValue(currentTns,true);
            uriList.setEnabled(true);
            otherNamespaceTextField.setEnabled(false);
        } else {
            uriList.setEnabled(false);
            if(otherNamespaceRadioButton.isVisible()) {
                otherNamespaceRadioButton.setSelected(true);
                otherNamespaceTextField.setText(currentTns);
                otherNamespaceTextField.setEnabled(true);
            }
        }
    }
    
    public void checkValidity() {
        boolean newValue = false;
        if(noNamespaceRadioButton.isSelected()) {
            newValue = true;
        } else if(schemaNamespaceRadioButton.isSelected()) {
            newValue = uriList.getSelectedValue()!=null;
        } else if(otherNamespaceRadioButton.isSelected()) {
            newValue = !otherNamespaceTextField.getText().equals("");
        }
        firePropertyChange(PROP_VALID_SELECTION,isValid,newValue);
        isValid = newValue;
    }

    public String getCurrentSelection() {
        if(schemaNamespaceRadioButton.isSelected()) {
            return (String) uriList.getSelectedValue();
        } else if (otherNamespaceRadioButton.isSelected()){
            String otherUri = otherNamespaceTextField.getText().trim();
            if (otherUri.length()>0) return otherUri;
        }
        return null;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if(source.equals(noNamespaceRadioButton)) {
            uriList.setEnabled(false);
            otherNamespaceTextField.setEnabled(false);
        } else if(source.equals(otherNamespaceRadioButton)){
            uriList.setEnabled(false);
            otherNamespaceTextField.setEnabled(true);
        } else if(source.equals(schemaNamespaceRadioButton)) {
            otherNamespaceTextField.setEnabled(false);
            uriList.setEnabled(true);
        }
        checkValidity();
    }

    public void valueChanged(ListSelectionEvent e) {
        checkValidity();
    }

    public void insertUpdate(DocumentEvent e) {
        checkValidity();
    }

    public void removeUpdate(DocumentEvent e) {
        checkValidity();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    public javax.swing.ButtonGroup buttonGroup1;
    public javax.swing.JScrollPane jScrollPane1;
    public javax.swing.JRadioButton noNamespaceRadioButton;
    public javax.swing.JRadioButton otherNamespaceRadioButton;
    public javax.swing.JTextField otherNamespaceTextField;
    public javax.swing.JRadioButton schemaNamespaceRadioButton;
    public javax.swing.JList uriList;
    // End of variables declaration//GEN-END:variables

}
