/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xml.api.scenario;

import javax.swing.event.ChangeListener;
import java.beans.PropertyChangeListener;
import org.openide.loaders.DataObject;

/**
 * <p>
 * All scenarios should implement this interface.
 * A scenario implementation is created by a ScenarioFactory.
 * </p>
 * <p><b>NOTE:</b></p>
 * <ul>
 * <li>All implementations are required to be serializable.</li>
 * <li>The toString() method of an implementation should return the name property
 *     of this scenario</li>
 * </ul>
 *
 * @author  asgeir@dimonsoftware.com
 * @deprecated Experimantal SPI
 */
@Deprecated
public interface Scenario {
    
    public static final String PROP_SCENARIO_MODIFIED = "SCENARIO_MODIFIED";
    
    /**
     * Registers PropertyChangeListener to receive events.
     * @param listener The listener to register.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener);
    
    /**
     * Removes PropertyChangeListener from the list of listeners.
     * @param listener The listener to remove.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener);
    
    /**
     * This method returns the a UI component which can be used to
     * customize this scenario.  To update changes done in the UI panel,
     * the saveChanges() method can be called.
     * A new or initialized instance of Component should be returned every
     * time this method is called.
     * @param dataObject The DataObject which owns this scenario
     * @param activatePropertyChange a flag that determines if PropertyChangeEvents are fired
     * @return A Component which can be used to customize this scenario
     */
    public java.awt.Component getCustomizer(DataObject dataObject, boolean activatePropertyChange);
    
    /**
     * Executes the DataObject using this scenario.
     * @param dataObject the DataObject to execute.
     */
    public void execute(DataObject dataObject);
    
    /**
     * Get the name of this scenario
     * @return The name of this scenario
     */
    public String getName();
    
    /**
     * Set the name of this scenario
     * @param name The name of this scenario
     */
    public void setName(String name);
    
    /**
     * Update this scenario with changes done by the last UI
     * component returned by the getUIComponent() method.
     */
    public void saveChanges();
    
}
